/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.dods.exceptions;

import java.awt.print.PrinterIOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.WriteAbortedException;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import java.rmi.activation.ActivationException;
import java.rmi.server.ServerCloneException;
import java.security.PrivilegedActionException;
import java.sql.SQLException;
import org.enhydra.dods.exceptions.DodsBaseException;
import org.xml.sax.SAXException;

public class DodsBaseExceptionUtil {
    private DodsBaseExceptionUtil() {
    }

    public static String makeMessage(Throwable cause) {
        String causeMsg = cause.getMessage();
        if (causeMsg == null) {
            return cause.getClass().getName();
        }
        return causeMsg;
    }

    public static String getMessage(DodsBaseException except, String superMsg) {
        Throwable cause = except.getCause();
        if (cause == null) {
            return superMsg;
        }
        String causeMsg = cause.getMessage();
        if (causeMsg == null || causeMsg.length() == 0) {
            causeMsg = cause.getClass().getName();
        }
        return superMsg + ": " + causeMsg;
    }

    private static void printChainedCauses(Throwable cause, PrintWriter out) {
        if (cause != null) {
            out.println("*** Caused by:");
            cause.printStackTrace(out);
            if (!(cause instanceof DodsBaseException)) {
                if (cause instanceof PrinterIOException) {
                    DodsBaseExceptionUtil.printChainedCauses(((PrinterIOException)cause).getIOException(), out);
                } else if (cause instanceof WriteAbortedException) {
                    DodsBaseExceptionUtil.printChainedCauses(((WriteAbortedException)cause).detail, out);
                } else if (cause instanceof ClassNotFoundException) {
                    DodsBaseExceptionUtil.printChainedCauses(((ClassNotFoundException)cause).getException(), out);
                } else if (cause instanceof ExceptionInInitializerError) {
                    DodsBaseExceptionUtil.printChainedCauses(((ExceptionInInitializerError)cause).getException(), out);
                } else if (cause instanceof InvocationTargetException) {
                    DodsBaseExceptionUtil.printChainedCauses(((InvocationTargetException)cause).getTargetException(), out);
                } else if (cause instanceof RemoteException) {
                    DodsBaseExceptionUtil.printChainedCauses(((RemoteException)cause).detail, out);
                } else if (cause instanceof ActivationException) {
                    DodsBaseExceptionUtil.printChainedCauses(((ActivationException)cause).detail, out);
                } else if (cause instanceof ServerCloneException) {
                    DodsBaseExceptionUtil.printChainedCauses(((ServerCloneException)cause).detail, out);
                } else if (cause instanceof PrivilegedActionException) {
                    DodsBaseExceptionUtil.printChainedCauses(((PrivilegedActionException)cause).getException(), out);
                } else if (cause instanceof SQLException) {
                    DodsBaseExceptionUtil.printChainedCauses(((SQLException)cause).getNextException(), out);
                } else if (cause instanceof SAXException) {
                    DodsBaseExceptionUtil.printChainedCauses(((SAXException)cause).getException(), out);
                }
            }
        }
    }

    public static void printCauseTrace(DodsBaseException except) {
        PrintWriter pw = new PrintWriter(System.err);
        DodsBaseExceptionUtil.printChainedCauses(except.getCause(), pw);
        pw.flush();
    }

    public static void printCauseTrace(DodsBaseException except, PrintStream s) {
        PrintWriter pw = new PrintWriter(s);
        DodsBaseExceptionUtil.printChainedCauses(except.getCause(), pw);
        pw.flush();
    }

    public static void printCauseTrace(DodsBaseException except, PrintWriter out) {
        DodsBaseExceptionUtil.printChainedCauses(except.getCause(), out);
        out.flush();
    }
}

