
/*
 * Enhydra Java Application Server Project
 * 
 * The contents of this file are subject to the Enhydra Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License on
 * the Enhydra web site ( http://www.enhydra.org/ ).
 * 
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See 
 * the License for the specific terms governing rights and limitations
 * under the License.
 * 
 * The Initial Developer of the Enhydra Application Server is Lutris
 * Technologies, Inc. The Enhydra Application Server and portions created
 * by Lutris Technologies, Inc. are Copyright Lutris Technologies, Inc.
 * All Rights Reserved.
 * 
 * Contributor(s):
 * 
 */
 
package org.enhydra.dods.statistics;

/**
 * This interface provides information about query statistics of the cache 
 * (DO (data object), simple query or complex query cache).
 *
 * @author    Tanja Jovanovic
 * @author    Nenad Vico
 * @author    Zorica Suvajdzin
 * @version   2.0  15.06.2003.
 */
 
public interface CacheStatistics {

    /**
     * Returns total number of times the cache was accessed.
     *
     * @return total number of times the cache was accessed.
     */
    public int getCacheAccessNum();

    /**
     * Sets total number of times the cache was accessed.
     *
     * @param num Total number of times the cache was accessed.
     */
    public void setCacheAccessNum(int num);

    /**
     * Increases total number of times the cache was accessed.
     */
    public void incrementCacheAccessNum(int num);

    /**
     * Returns number of cache accesses that were successful.
     *
     * @return Number of cache accesses that were successful.
     */
    public int getCacheHitsNum();

    /**
     * Sets number of qof cache accesses that were successful.
     *
     * @param cacheHitsNum Number of of cache accesses that were successful.
     */
    public void setCacheHitsNum(int cacheHitsNum);

    /**
     * Increases of cache accesses that were successful.
     */
    public void incrementCacheHitsNum(int num);

    /**
     * Returns how much cache is currently used. This value is given in percents.
     * If cache is unbounded, method returns 100%.
     *
     * @return Percents - how much cache is currently used. 
     
     */
    public double getUsedPercents();
        
    /**
     * Returns how many cache accesses were successful. 
     * This value is given in percents.
     *
     * @return Percents - how many cache accesses were successful. 
     */
    public double getCacheHitsPercents();
        
    /**
     * Clears statistics. Sets everything to null.
     */
    public void clearStatistics();
}
