
/*
 * Enhydra Java Application Server Project
 * 
 * The contents of this file are subject to the Enhydra Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License on
 * the Enhydra web site ( http://www.enhydra.org/ ).
 * 
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See 
 * the License for the specific terms governing rights and limitations
 * under the License.
 * 
 * The Initial Developer of the Enhydra Application Server is Lutris
 * Technologies, Inc. The Enhydra Application Server and portions created
 * by Lutris Technologies, Inc. are Copyright Lutris Technologies, Inc.
 * All Rights Reserved.
 * 
 * Contributor(s):
 * 
 * $Id: DataObjectException.java,v 1.1 2004/09/03 13:42:37 sinisa Exp $
 */
package com.lutris.dods.builder.generator.query;

import org.enhydra.dods.exceptions.DodsBaseException;

/**
 * DataObjectException class, used by Business Objects, catch all the 
 * DataObject Exceptions, will be passed to POs and handled there. 
 * Need to state the reasons.<p>
 * <b>Usage:</b><p>
 * <dd> import myapp.business.*;<p>
 *
 * <dd> try {<br>
 * <dd> some access of DOs<br>
 * <dd> }<br>
 * <dd>     catch (SQLException sqlEx) {
 * <dd>        if (sqlEx.getSQLState().startsWith("02") &&
 * <dd>           (sqlEx.getErrorCode() == 100)) {
 * <dd>           String msg = "Update or delete DO is out of synch";
 * <dd>           throw new DataObjectException(msg, sqlEx);
 * <dd>        }
 * <dd>        else if (sqlEx.getSQLState().equals("S1000") &&
 * <dd>           (sqlEx.getErrorCode() == -268)) {
 * <dd>           String msg = "Integrity constraint violation";
 * <dd>           throw new DataObjectException(msg, sqlEx);
 * <dd>        }
 * <dd>        else {
 * <dd>            String msg = "Data Object Error";
 * <dd>           throw new DataObjectException(msg, sqlEx);
 * <dd>        }
 * <dd>     }
 * <dd>     catch (DatabaseManagerException connEx) {
 * <dd>        String msg = "Database connection Error";
 * <dd>        throw new DataObjectException(msg, connEx);
 * <dd>     }
 * <dd>     catch (ObjectIdException oidEx) {
 * <dd>        String msg = "Object ID Error";
 * <dd>        throw new DataObjectException(msg, oidEx);
 * <dd>     }
 *
 * @version $Revision: 1.1 $
 */
public class DataObjectException extends DodsBaseException {

    /**
     * Construct a exception without a specified cause.
     *
     * @param msg The message associated with the exception.
     */
    public DataObjectException(String  msg) {
        super(msg);
    }

    /**
     * Construct a exception with an associated causing exception.
     *
     * @param msg The message associated with the exception.
     * @param cause The error or exception that cause this
     *  exception.
     */
    public DataObjectException(String  msg,
            Throwable  cause) {
        super(msg, cause);
    }
}
