
/*
 * Enhydra Java Application Server Project
 * 
 * The contents of this file are subject to the Enhydra Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License on
 * the Enhydra web site ( http://www.enhydra.org/ ).
 * 
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See 
 * the License for the specific terms governing rights and limitations
 * under the License.
 * 
 * The Initial Developer of the Enhydra Application Server is Lutris
 * Technologies, Inc. The Enhydra Application Server and portions created
 * by Lutris Technologies, Inc. are Copyright Lutris Technologies, Inc.
 * All Rights Reserved.
 * 
 * Contributor(s):
 * 
 * $Id: Query.java,v 1.1 2004/09/03 13:42:37 sinisa Exp $
 */
package com.lutris.appserver.server.sql;

import java.sql.ResultSet ;
import java.sql.SQLException ;

/**
 * Interface that must be implemented by objects accessed by DBQuery.
 *
 * @author  Kyle Clark
 * @version $Revision: 1.1 $
 * @see     DBQuery
 */
public interface Query {

    /**
     * Method to query objects from the database.
     *
     * @param conn Handle to database connection.
     * @exception java.sql.SQLException If a database access error occurs. 
     */
    public ResultSet  executeQuery(DBConnection conn)
        throws SQLException ;

    /**
     * Method to get next object from query results.
     *
     * @param rs JDBC result set from which the next object
     *   will be instantiated.
     * @exception java.sql.SQLException If a database access error occurs. 
     * @exception ObjectIdException If ObjectId was not found.
     */
    public Object  next(ResultSet  rs)
        throws SQLException , ObjectIdException;
}
