
/*
 * Enhydra Java Application Server Project
 * 
 * The contents of this file are subject to the Enhydra Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License on
 * the Enhydra web site ( http://www.enhydra.org/ ).
 * 
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See 
 * the License for the specific terms governing rights and limitations
 * under the License.
 * 
 * The Initial Developer of the Enhydra Application Server is Lutris
 * Technologies, Inc. The Enhydra Application Server and portions created
 * by Lutris Technologies, Inc. are Copyright Lutris Technologies, Inc.
 * All Rights Reserved.
 * 
 * Contributor(s):
 * 
 * $Id: DBRowUpdateException.java,v 1.1 2004/09/03 13:42:37 sinisa Exp $
 */
package com.lutris.appserver.server.sql;

/**
 * DBRowUpdateException is thrown when a CoreDO update fails.
 *
 * Two values are used to uniquely identify a row in a table:
 *    oId and version.
 * The executeUpdate() method creates an SQL UPDATE command
 * to write the new values in a CoreDO object back to
 * the correct row in the database.
 * The row is identifed by the oId and version values specified
 * in the WHERE-clause of the UPDATE command.
 *
 * So, if no row has the specified oId and version combination,
 * the UPDATE will fail, and report that 0 rows were updated.
 * Note: other database problems (e.g. disk full) can also cause
 * an UPDATE to fail, but these are rare.
 *
 * When versioning == true, the executeUpdate() method will increment
 * the version number in both the CoreDO object and in the updated row.
 *
 * When the same oId/version combination is used twice to create
 * two CoreDO objects (A and B) that refer to the same row,
 * it is possible for the version number of one of those objects
 * to become out-of-sync with the row in the database.
 * Object A is updated, and the version number in object A and
 * in the row is incremented.
 * When an attempt is made to update object B, the version number in
 * object B no longer matches the row in the database,
 * so the row is not found, and the update has no effect
 * (zero rows are updated).
 * In this case, the CoreDO.executeUpdate() method throws
 * a DBRowUpdateException describing the problem.
 *
 * The application code that catches this exception
 * should probably reload the Data Object from the database.
 *
 * @version $Revision: 1.1 $
 * @see     CoreDO
 * @author  Jay Gunter
 */
public class DBRowUpdateException extends java.sql.SQLException  {

    /**
     * Construct a exception without a specified cause.
     *
     * @param msg The message associated with the exception.
     */
    public DBRowUpdateException(String  msg) {
        super(msg);
    }
}
