/*
 * Decompiled with CFR 0.152.
 */
package com.lutris.appserver.server.sql;

import com.lutris.appserver.server.sql.ObjectIdException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;

public class ObjectId
implements Serializable {
    private BigDecimal value;
    public static final BigDecimal ONE = new BigDecimal("1");
    public static final BigDecimal MAX = new BigDecimal("9999999999999999999");

    public ObjectId(String val, int radix) throws ObjectIdException, NumberFormatException {
        this.value = new BigDecimal(new BigInteger(val, radix), 0);
        if (this.value.signum() < 0) {
            throw new ObjectIdException("Object IDs cannot be negative.");
        }
        if (this.value.compareTo(MAX) > 0) {
            throw new ObjectIdException("Object IDs cannot exceed " + MAX.toString());
        }
    }

    public ObjectId(String val) throws ObjectIdException, NumberFormatException {
        this.value = new BigDecimal(new BigInteger(val), 0);
        if (this.value.signum() < 0) {
            throw new ObjectIdException("Object IDs cannot be negative.");
        }
        if (this.value.compareTo(MAX) > 0) {
            throw new ObjectIdException("Object IDs cannot exceed " + MAX.toString());
        }
    }

    public ObjectId(long val) throws ObjectIdException {
        if (val < 0L) {
            throw new ObjectIdException("Object IDs cannot be negative.");
        }
        this.value = BigDecimal.valueOf(val);
        if (this.value.compareTo(MAX) > 0) {
            throw new ObjectIdException("Object IDs cannot exceed " + MAX.toString());
        }
    }

    public ObjectId(BigDecimal val) throws ObjectIdException {
        if (val.signum() < 0) {
            throw new ObjectIdException("Object IDs cannot be negative.");
        }
        if (val.scale() > 0) {
            throw new ObjectIdException("Object IDs cannot have a scale greater than zero.");
        }
        if (val.compareTo(MAX) > 0) {
            throw new ObjectIdException("Object IDs cannot exceed " + MAX.toString());
        }
        this.value = val;
    }

    public ObjectId add(ObjectId val) throws ObjectIdException {
        return new ObjectId(this.value.add(val.toBigDecimal()));
    }

    public ObjectId add(long val) throws ObjectIdException {
        return new ObjectId(this.value.add(BigDecimal.valueOf(val)));
    }

    public ObjectId increment() throws ObjectIdException {
        return new ObjectId(this.value.add(ONE));
    }

    public BigDecimal toBigDecimal() {
        return this.value;
    }

    public boolean equals(ObjectId oid) {
        return oid.toBigDecimal().compareTo(this.value) == 0;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.value.toString();
    }
}

