
/*
 * Enhydra Java Application Server Project
 *
 * The contents of this file are subject to the Enhydra Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License on
 * the Enhydra web site ( http://www.enhydra.org/ ).
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific terms governing rights and limitations
 * under the License.
 *
 * The Initial Developer of the Enhydra Application Server is Lutris
 * Technologies, Inc. The Enhydra Application Server and portions created
 * by Lutris Technologies, Inc. are Copyright Lutris Technologies, Inc.
 * All Rights Reserved.
 *
 * Contributor(s):
 *
 * $Id: DodsBaseExceptionUtil.java,v 1.1 2004/09/03 13:42:37 sinisa Exp $
 *
 * formatted with JxBeauty (c) johann.langhofer@nextra.at
 */


package  org.enhydra.dods.exceptions;

import  java.io.*;


/**
 * Utilities used to implement the DodsBaseException.
 */
// compliance with WEBDOCWF begin
// WebDocWf extension
// The following line has been changed:
public class DodsBaseExceptionUtil {

  // before : class ChainedThrowableUtil {
 // end of WebDocWf extension
 // original line
 // class ChainedThrowableUtil {
 // compliance with WEBDOCWF end
 /**
   * Can't makes instances.
   */
  private DodsBaseExceptionUtil () {
  }

  /**
   * Generate the message to set for the exception message.
   * When not explicit message is supplied.
   */
  // compliance with WEBDOCWF begin
 // WebDocWf extension
 // The following line has been changed:
 public static String  makeMessage (Throwable  cause) {
    // before:     protected static String makeMessage(Throwable cause) {
 // end of WebDocWf extension
 // original line
 //protected static String makeMessage(Throwable cause) {
 // compliance with WEBDOCWF end
 String  causeMsg = cause.getMessage();
    if (causeMsg == null) {
      return  cause.getClass().getName();
    }
    else {
      return  causeMsg;
    }
  }

  /**
   * Get the message associated with this exception.
   */
  // compliance with WEBDOCWF begin
 // WebDocWf extension
 // The following line has been changed:
 public static String  getMessage (DodsBaseException except, String  superMsg) {
    //before:    protected static String getMessage(DodsBaseException except, String superMsg) {
 // end of WebDocWf extension
 // original line
 // protected static String getMessage(DodsBaseException except,
 // String superMsg) {
 // compliance with WEBDOCWF end
 Throwable  cause = except.getCause();
    if (cause == null) {
      return  superMsg;
    }
    else {
      String  causeMsg = cause.getMessage();
      if ((causeMsg == null) || (causeMsg.length() == 0)) {
        causeMsg = cause.getClass().getName();
      }
      return  superMsg + ": " + causeMsg;
    }
  }

  /**
   * Do work of printing the causes of a chained exception.  This is
   * recursive. This attempts to following causing exceptions that are
   * chained in other types of exception objects.  If only Sun would
   * standardize a mechanism in throwable instead of letting it accumulate
   * in an ad-hoc manner.
   */
  private static void printChainedCauses (Throwable  cause, PrintWriter out) {
    if (cause != null) {
      out.println("*** Caused by:");
      cause.printStackTrace(out);
      if (cause instanceof DodsBaseException) {
      // If cause was is a DodsBaseException, its chain has already
 // been followed, otherwise, see what we can do.
      }
      else if (cause instanceof java.awt.print.PrinterIOException ) {
        printChainedCauses(((java.awt.print.PrinterIOException )cause).getIOException(),
            out);
      }
      else if (cause instanceof java.io.WriteAbortedException ) {
        printChainedCauses(((java.io.WriteAbortedException )cause).detail, out);
      }
      else if (cause instanceof java.lang.ClassNotFoundException ) {
        printChainedCauses(((java.lang.ClassNotFoundException )cause).getException(),
            out);
      }
      else if (cause instanceof java.lang.ExceptionInInitializerError ) {
        printChainedCauses(((java.lang.ExceptionInInitializerError )cause).getException(),
            out);
      }
      else if (cause instanceof java.lang.reflect.InvocationTargetException ) {
        printChainedCauses(((java.lang.reflect.InvocationTargetException )cause).getTargetException(),
            out);
      }
      else if (cause instanceof java.rmi.RemoteException ) {
        printChainedCauses(((java.rmi.RemoteException )cause).detail, out);
      }
      else if (cause instanceof java.rmi.activation.ActivationException ) {
        printChainedCauses(((java.rmi.activation.ActivationException )cause).detail,
            out);
      }
      else if (cause instanceof java.rmi.server.ServerCloneException ) {
        printChainedCauses(((java.rmi.server.ServerCloneException )cause).detail,
            out);
      }
      else if (cause instanceof java.security.PrivilegedActionException ) {
        printChainedCauses(((java.security.PrivilegedActionException )cause).getException(),
            out);
      }
      else if (cause instanceof java.sql.SQLException ) {
        printChainedCauses(((java.sql.SQLException )cause).getNextException(),
            out);
      }
      else if (cause instanceof org.xml.sax.SAXException ) {
        printChainedCauses(((org.xml.sax.SAXException )cause).getException(),
            out);
      }
    }
  }

  /**
   * Prints stacktrace and cause stacktrace.
   */
  // compliance with WEBDOCWF begin
 // WebDocWf extension
 // The following line has been changed:
 public static void printCauseTrace (DodsBaseException except) {
    //before:    protected static void printCauseTrace(DodsBaseException except) {
 // end of WebDocWf extension
 // original line
 // protected static void printCauseTrace(DodsBaseException except) {
 // compliance with WEBDOCWF end
    PrintWriter pw = new PrintWriter(System.err);
    printChainedCauses(except.getCause(), pw);
    pw.flush();
  }

  /**
   * Prints stacktrace and cause stacktrace.
   */
  // compliance with WEBDOCWF begin
 // WebDocWf extension
 // The following line has been changed:
 public static void printCauseTrace (DodsBaseException except, PrintStream s) {
    //before:    protected static void printCauseTrace(DodsBaseException except, PrintStream s) {
 // end of WebDocWf extension
 // original line
 // protected static void printCauseTrace(DodsBaseException except,
 //PrintStream s) {
 // compliance with WEBDOCWF end
    PrintWriter pw = new PrintWriter(s);
    printChainedCauses(except.getCause(), pw);
    pw.flush();
  }

  /**
   * Prints stacktrace and cause stacktrace.
   */
  public static void printCauseTrace (DodsBaseException except, PrintWriter out) {
    printChainedCauses(except.getCause(), out);
    out.flush();
  }
}



