
//Enhydra API javadoc generation
/*
 * Enhydra Java Application Server Project
 * 
 * The contents of this file are subject to the Enhydra Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License on
 * the Enhydra web site ( http://www.enhydra.org/ ).
 * 
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See 
 * the License for the specific terms governing rights and limitations
 * under the License.
 * 
 * The Initial Developer of the Enhydra Application Server is Lutris
 * Technologies, Inc. The Enhydra Application Server and portions created
 * by Lutris Technologies, Inc. are Copyright Lutris Technologies, Inc.
 * All Rights Reserved.
 * 
 * Contributor(s):
 * 
 * $Id: DodsBaseException.java,v 1.1 2004/09/03 13:42:37 sinisa Exp $
 */

package org.enhydra.dods.exceptions;

import java.io.*;

/**
 * Exception used as a base for creating an exception that has a chain of
 * exceptions that lead to the derived exception.  Very useful for interfaces
 * where the implementation exception is not known.
 */
public class DodsBaseException extends Exception  {
    private Throwable  cause;

    /**
     * Construct an exception without a specified cause.
     *
     * @param msg The message associated with the exception.
     */
    public DodsBaseException(String  msg) {
        super(msg);
        cause = null;
    }

    /**
     * Construct an exception with an associated causing exception.
     *
     * @param msg The message associated with the exception.
     * @param cause The error or exception that cause this
     *  exception.
     */
    public DodsBaseException(String  msg,
                            Throwable  cause) {
        super(msg);
        this.cause = cause;
    }

    /**
     * Construct an exception from a causing exception.
     *
     * @param cause The error or exception that cause this
     *  exception. The message will be take be this object's
     *  messasge.
     */
    public DodsBaseException(Throwable  cause) {
        super(DodsBaseExceptionUtil.makeMessage(cause));
        this.cause = cause;
    }

    /**
     * Return the message associated with this exception.  If causes
     * are included, they will be appended to the message.
     */
    public String  getMessage() {
        return DodsBaseExceptionUtil.getMessage(this, super.getMessage());
    }

    /**
     * Get the causing exception associated with this exception.
     * @return The causing exception or null if no cause is specified.
     */
    public Throwable  getCause() {
        return cause;
    }

    /**
     * Prints this ChainedException and its backtrace, and the causes
     * and their stack traces to the standard error stream. 
     */
    public void printStackTrace() {
        super.printStackTrace();
        DodsBaseExceptionUtil.printCauseTrace(this);
    }

    /**
     * Prints this ChainedException and its backtrace, and the causes
     * and their stack traces to the e specified print stream. 
     */
    public void printStackTrace(PrintStream s) {
        super.printStackTrace(s);
        DodsBaseExceptionUtil.printCauseTrace(this, s);
    }

    /**
     * Prints this ChainedException and its backtrace, and the causes
     * and their stack traces to the e specified print writer. 
     */
    public void printStackTrace(PrintWriter s) {
        super.printStackTrace(s);
        DodsBaseExceptionUtil.printCauseTrace(this, s);
    }
    
    
    
    
}
