/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import EDU.oswego.cs.dl.util.concurrent.Channel;
import EDU.oswego.cs.dl.util.concurrent.Executor;
import EDU.oswego.cs.dl.util.concurrent.SynchronousChannel;
import EDU.oswego.cs.dl.util.concurrent.ThreadFactoryUser;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class PooledExecutor
extends ThreadFactoryUser
implements Executor {
    public static final int DEFAULT_MAXIMUMPOOLSIZE = Integer.MAX_VALUE;
    public static final int DEFAULT_MINIMUMPOOLSIZE = 1;
    public static final long DEFAULT_KEEPALIVETIME = 60000L;
    protected int maximumPoolSize_ = Integer.MAX_VALUE;
    protected int minimumPoolSize_ = 1;
    protected int poolSize_ = 0;
    protected long keepAliveTime_ = 60000L;
    protected boolean shutdown_ = false;
    protected final Channel handOff_;
    protected final Map threads_;
    protected BlockedExecutionHandler blockedExecutionHandler_;

    public PooledExecutor() {
        this(new SynchronousChannel(), Integer.MAX_VALUE);
    }

    public PooledExecutor(int maxPoolSize) {
        this(new SynchronousChannel(), maxPoolSize);
    }

    public PooledExecutor(Channel channel) {
        this(channel, Integer.MAX_VALUE);
    }

    public PooledExecutor(Channel channel, int maxPoolSize) {
        this.maximumPoolSize_ = maxPoolSize;
        this.handOff_ = channel;
        this.runWhenBlocked();
        this.threads_ = new HashMap();
    }

    public synchronized int getMaximumPoolSize() {
        return this.maximumPoolSize_;
    }

    public synchronized void setMaximumPoolSize(int newMaximum) {
        if (newMaximum <= 0) {
            throw new IllegalArgumentException();
        }
        this.maximumPoolSize_ = newMaximum;
    }

    public synchronized int getMinimumPoolSize() {
        return this.minimumPoolSize_;
    }

    public synchronized void setMinimumPoolSize(int newMinimum) {
        if (newMinimum < 0) {
            throw new IllegalArgumentException();
        }
        this.minimumPoolSize_ = newMinimum;
    }

    public synchronized int getPoolSize() {
        return this.poolSize_;
    }

    public synchronized long getKeepAliveTime() {
        return this.keepAliveTime_;
    }

    public synchronized void setKeepAliveTime(long msecs) {
        this.keepAliveTime_ = msecs;
    }

    public synchronized BlockedExecutionHandler getBlockedExecutionHandler() {
        return this.blockedExecutionHandler_;
    }

    public synchronized void setBlockedExecutionHandler(BlockedExecutionHandler h) {
        this.blockedExecutionHandler_ = h;
    }

    protected void addThread(Runnable command) {
        Worker worker = new Worker(command);
        Thread thread = this.getThreadFactory().newThread(worker);
        this.threads_.put(worker, thread);
        ++this.poolSize_;
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int createThreads(int numberOfThreads) {
        int ncreated = 0;
        for (int i = 0; i < numberOfThreads; ++i) {
            PooledExecutor pooledExecutor = this;
            synchronized (pooledExecutor) {
                if (this.poolSize_ < this.maximumPoolSize_) {
                    this.addThread(null);
                    ++ncreated;
                } else {
                    break;
                }
                continue;
            }
        }
        return ncreated;
    }

    public synchronized void interruptAll() {
        for (Thread t : this.threads_.values()) {
            t.interrupt();
        }
    }

    public void shutdownNow() {
        this.shutdownNow(new DiscardWhenBlocked());
    }

    public synchronized void shutdownNow(BlockedExecutionHandler handler) {
        this.setBlockedExecutionHandler(handler);
        this.shutdown_ = true;
        this.maximumPoolSize_ = 0;
        this.minimumPoolSize_ = 0;
        this.interruptAll();
    }

    public void shutdownAfterProcessingCurrentlyQueuedTasks() {
        this.shutdownAfterProcessingCurrentlyQueuedTasks(new DiscardWhenBlocked());
    }

    public synchronized void shutdownAfterProcessingCurrentlyQueuedTasks(BlockedExecutionHandler handler) {
        this.setBlockedExecutionHandler(handler);
        this.shutdown_ = true;
        if (this.poolSize_ == 0) {
            this.maximumPoolSize_ = 0;
            this.minimumPoolSize_ = 0;
        }
    }

    public synchronized boolean isTerminatedAfterShutdown() {
        return this.shutdown_ && this.poolSize_ == 0;
    }

    public synchronized boolean awaitTerminationAfterShutdown(long maxWaitTime) throws InterruptedException {
        if (!this.shutdown_) {
            throw new IllegalStateException();
        }
        if (this.poolSize_ == 0) {
            return true;
        }
        long waitTime = maxWaitTime;
        if (waitTime <= 0L) {
            return false;
        }
        long start = System.currentTimeMillis();
        do {
            this.wait(waitTime);
            if (this.poolSize_ != 0) continue;
            return true;
        } while ((waitTime = maxWaitTime - (System.currentTimeMillis() - start)) > 0L);
        return false;
    }

    public synchronized void awaitTerminationAfterShutdown() throws InterruptedException {
        if (!this.shutdown_) {
            throw new IllegalStateException();
        }
        while (this.poolSize_ > 0) {
            this.wait();
        }
    }

    public List drain() {
        boolean wasInterrupted = false;
        Vector<Object> tasks = new Vector<Object>();
        while (true) {
            try {
                Object x;
                while ((x = this.handOff_.poll(0L)) != null) {
                    tasks.addElement(x);
                }
            }
            catch (InterruptedException ex) {
                wasInterrupted = true;
                continue;
            }
            break;
        }
        if (wasInterrupted) {
            Thread.currentThread().interrupt();
        }
        return tasks;
    }

    protected synchronized void workerDone(Worker w) {
        this.threads_.remove(w);
        if (--this.poolSize_ == 0 && this.shutdown_) {
            this.minimumPoolSize_ = 0;
            this.maximumPoolSize_ = 0;
            this.notifyAll();
        }
        if (this.poolSize_ == 0 || this.poolSize_ < this.minimumPoolSize_) {
            try {
                Runnable r = (Runnable)this.handOff_.poll(0L);
                if (r != null && !this.shutdown_) {
                    this.addThread(r);
                }
            }
            catch (InterruptedException ie) {
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Runnable getTask() throws InterruptedException {
        long waitTime;
        PooledExecutor pooledExecutor = this;
        synchronized (pooledExecutor) {
            if (this.poolSize_ > this.maximumPoolSize_) {
                return null;
            }
            waitTime = this.shutdown_ ? 0L : this.keepAliveTime_;
        }
        if (waitTime >= 0L) {
            return (Runnable)this.handOff_.poll(waitTime);
        }
        return (Runnable)this.handOff_.take();
    }

    public void runWhenBlocked() {
        this.setBlockedExecutionHandler(new RunWhenBlocked());
    }

    public void waitWhenBlocked() {
        this.setBlockedExecutionHandler(new WaitWhenBlocked());
    }

    public void discardWhenBlocked() {
        this.setBlockedExecutionHandler(new DiscardWhenBlocked());
    }

    public void abortWhenBlocked() {
        this.setBlockedExecutionHandler(new AbortWhenBlocked());
    }

    public void discardOldestWhenBlocked() {
        this.setBlockedExecutionHandler(new DiscardOldestWhenBlocked());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Runnable command) throws InterruptedException {
        do {
            PooledExecutor pooledExecutor = this;
            synchronized (pooledExecutor) {
                if (!this.shutdown_) {
                    int size = this.poolSize_;
                    if (size < this.minimumPoolSize_) {
                        this.addThread(command);
                        return;
                    }
                    if (this.handOff_.offer(command, 0L)) {
                        return;
                    }
                    if (size < this.maximumPoolSize_) {
                        this.addThread(command);
                        return;
                    }
                }
            }
        } while (!this.getBlockedExecutionHandler().blockedAction(command));
    }

    protected class DiscardOldestWhenBlocked
    implements BlockedExecutionHandler {
        protected DiscardOldestWhenBlocked() {
        }

        @Override
        public boolean blockedAction(Runnable command) throws InterruptedException {
            PooledExecutor.this.handOff_.poll(0L);
            if (!PooledExecutor.this.handOff_.offer(command, 0L)) {
                command.run();
            }
            return true;
        }
    }

    protected class AbortWhenBlocked
    implements BlockedExecutionHandler {
        protected AbortWhenBlocked() {
        }

        @Override
        public boolean blockedAction(Runnable command) {
            throw new RuntimeException("Pool is blocked");
        }
    }

    protected class DiscardWhenBlocked
    implements BlockedExecutionHandler {
        protected DiscardWhenBlocked() {
        }

        @Override
        public boolean blockedAction(Runnable command) {
            return true;
        }
    }

    protected class WaitWhenBlocked
    implements BlockedExecutionHandler {
        protected WaitWhenBlocked() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean blockedAction(Runnable command) throws InterruptedException {
            PooledExecutor pooledExecutor = PooledExecutor.this;
            synchronized (pooledExecutor) {
                if (PooledExecutor.this.shutdown_) {
                    return true;
                }
            }
            PooledExecutor.this.handOff_.put(command);
            return true;
        }
    }

    protected class RunWhenBlocked
    implements BlockedExecutionHandler {
        protected RunWhenBlocked() {
        }

        @Override
        public boolean blockedAction(Runnable command) {
            command.run();
            return true;
        }
    }

    public static interface BlockedExecutionHandler {
        public boolean blockedAction(Runnable var1) throws InterruptedException;
    }

    protected class Worker
    implements Runnable {
        protected Runnable firstTask_;

        protected Worker(Runnable firstTask) {
            this.firstTask_ = firstTask;
        }

        @Override
        public void run() {
            try {
                Runnable task = this.firstTask_;
                this.firstTask_ = null;
                if (task != null) {
                    task.run();
                    task = null;
                }
                while ((task = PooledExecutor.this.getTask()) != null) {
                    task.run();
                    task = null;
                }
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                PooledExecutor.this.workerDone(this);
            }
        }
    }
}

