/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out.fo.renderers;

import jakarta.xml.bind.JAXBContext;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.URI;
import java.util.List;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopConfParser;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.apps.FopFactoryBuilder;
import org.apache.fop.apps.FormattingResults;
import org.apache.fop.apps.PageSequenceResults;
import org.apache.xmlgraphics.io.ResourceResolver;
import org.docx4j.Docx4jProperties;
import org.docx4j.XmlUtils;
import org.docx4j.convert.out.FORenderer;
import org.docx4j.convert.out.FOSettings;
import org.docx4j.convert.out.fo.AbstractPlaceholderLookup;
import org.docx4j.convert.out.fo.PlaceholderReplacementHandler;
import org.docx4j.convert.out.fo.renderers.AbstractFORenderer;
import org.docx4j.events.EventFinished;
import org.docx4j.events.PackageIdentifier;
import org.docx4j.events.ProcessStep;
import org.docx4j.events.StartEvent;
import org.docx4j.events.WellKnownProcessSteps;
import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.utils.XmlSerializerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class FORendererApacheFOP
extends AbstractFORenderer {
    protected static Logger log = LoggerFactory.getLogger(FORendererApacheFOP.class);
    protected static FORendererApacheFOP instance = null;
    private static String XSL_FO = "http://www.w3.org/1999/XSL/Format";
    private static final String FO_USER_AGENT = "foUserAgent";
    public static final String FOP_FACTORY = "fopFactory";

    public void render(String foDocument, FOSettings settings, boolean twoPass, List<FORenderer.SectionPageInformation> pageNumberInformation, OutputStream outputStream) throws Docx4JException {
        StartEvent startEvent;
        String apacheFopMime = this.setupApacheFopMime(settings);
        StreamSource foDocumentSrc = new StreamSource(new StringReader(foDocument));
        FopPlaceholderLookup placeholderLookup = null;
        FormattingResults formattingResults = null;
        FopFactory fopFactory = null;
        if (settings.getSettings().get(FOP_FACTORY) == null) {
            try {
                FopFactoryBuilder fopFactoryBuilder = FORendererApacheFOP.getFopFactoryBuilder(settings);
                fopFactory = fopFactoryBuilder.build();
                FOUserAgent fOUserAgent = FORendererApacheFOP.getFOUserAgent(settings, fopFactory);
            }
            catch (FOPException e) {
                throw new Docx4JException("FOUserAgent issue", (Exception)((Object)e));
            }
        } else {
            fopFactory = (FopFactory)settings.getSettings().get(FOP_FACTORY);
        }
        if (twoPass) {
            log.debug("1st pass in 2 pass");
            startEvent = new StartEvent((PackageIdentifier)settings.getOpcPackage(), (ProcessStep)WellKnownProcessSteps.FOP_RENDER_PASS1);
            startEvent.publish();
            placeholderLookup = new FopPlaceholderLookup(pageNumberInformation);
            formattingResults = this.calcResults(fopFactory, apacheFopMime, foDocumentSrc, placeholderLookup);
            placeholderLookup.setResults(formattingResults);
            foDocumentSrc = new StreamSource(new StringReader(foDocument));
            new EventFinished(startEvent).publish();
        }
        if (this.TEXTBOX_POSTPROCESSING_REQUIRED) {
            DOMResult result = new DOMResult();
            XmlUtils.transform((Source)foDocumentSrc, (Templates)xslt_POSTPROCESSING, null, (Result)result);
            Document docResult = (Document)result.getNode();
            String modifiedFO = XmlUtils.w3CDomNodeToString((Node)docResult);
            log.debug("After moving! \n" + modifiedFO);
            foDocumentSrc = new StreamSource(new StringReader(modifiedFO));
        }
        startEvent = new StartEvent((PackageIdentifier)settings.getOpcPackage(), (ProcessStep)WellKnownProcessSteps.FOP_RENDER_PASS1);
        startEvent.publish();
        FOUserAgent foUserAgent = (FOUserAgent)settings.getSettings().get(FO_USER_AGENT);
        this.render(fopFactory, foUserAgent, apacheFopMime, foDocumentSrc, placeholderLookup, outputStream);
        new EventFinished(startEvent).publish();
    }

    private String setupApacheFopMime(FOSettings settings) {
        String ret = settings.getApacheFopMime();
        if (ret == null) {
            ret = "application/pdf";
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FORenderer getInstance() {
        if (instance != null) return instance;
        Class<FORendererApacheFOP> clazz = FORendererApacheFOP.class;
        synchronized (FORendererApacheFOP.class) {
            if (instance != null) return instance;
            instance = new FORendererApacheFOP();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    protected void render(FopFactory fopFactory, FOUserAgent foUserAgent, String outputFormat, Source foDocumentSrc, PlaceholderReplacementHandler.PlaceholderLookup placeholderLookup, OutputStream outputStream) throws Docx4JException {
        Fop fop = null;
        SAXResult result = null;
        try {
            fop = foUserAgent == null ? fopFactory.newFop(outputFormat, outputStream) : fopFactory.newFop(outputFormat, foUserAgent, outputStream);
            result = placeholderLookup == null ? new SAXResult(fop.getDefaultHandler()) : new SAXResult(new PlaceholderReplacementHandler(fop.getDefaultHandler(), placeholderLookup));
        }
        catch (FOPException e) {
            throw new Docx4JException("Exception setting up result for fo transformation: " + e.getMessage(), (Exception)((Object)e));
        }
        XmlSerializerUtil.serialize((Source)foDocumentSrc, (Result)result, (boolean)false, (boolean)false);
    }

    protected FormattingResults calcResults(FopFactory fopFactory, String outputFormat, Source foDocumentSrc, PlaceholderReplacementHandler.PlaceholderLookup placeholderLookup) throws Docx4JException {
        Fop fop = null;
        SAXResult result = null;
        try {
            fop = fopFactory.newFop(outputFormat, (OutputStream)new NullOutputStream());
            result = new SAXResult(new PlaceholderReplacementHandler(fop.getDefaultHandler(), placeholderLookup));
        }
        catch (FOPException e) {
            throw new Docx4JException("Exception setting up result for fo transformation: " + e.getMessage(), (Exception)((Object)e));
        }
        XmlSerializerUtil.serialize((Source)foDocumentSrc, (Result)result, (boolean)false, (boolean)false);
        return fop.getResults();
    }

    public static FOUserAgent getFOUserAgent(FOSettings settings, FopFactory fopFactory) throws Docx4JException, FOPException {
        if (fopFactory == null) {
            throw new Docx4JException("FopFactory is null");
        }
        settings.getSettings().put(FOP_FACTORY, fopFactory);
        FOUserAgent foUserAgent = fopFactory.newFOUserAgent();
        settings.getSettings().put(FO_USER_AGENT, foUserAgent);
        return foUserAgent;
    }

    public static FopFactoryBuilder getFopFactoryBuilder(FOSettings settings) throws FOPException {
        return FORendererApacheFOP.getFopFactoryBuilder(settings, null);
    }

    public static FopFactoryBuilder getFopFactoryBuilder(FOSettings settings, ResourceResolver resourceResolver) throws FOPException {
        org.docx4j.convert.out.fopconf.Fop fopConfig = settings.getFopConfig();
        String userConfig = XmlUtils.marshaltoString((Object)fopConfig, (JAXBContext)Context.getFopConfigContext());
        if (log.isDebugEnabled()) {
            log.debug(userConfig);
        }
        InputStream is = IOUtils.toInputStream((String)userConfig, (String)"UTF-8");
        try {
            String baseUriProperty = Docx4jProperties.getProperty((String)"docx4j.convert.out.fop.FopConfParser.defaultBaseURI");
            URI defaultBaseURI = null;
            if (baseUriProperty == null) {
                log.debug("Using defaultBaseURI");
                defaultBaseURI = new File(".").toURI();
            } else {
                log.debug("Using baseURI " + baseUriProperty);
                defaultBaseURI = new URI(baseUriProperty);
            }
            FopConfParser fopConfParser = null;
            fopConfParser = resourceResolver == null ? new FopConfParser(is, defaultBaseURI) : new FopConfParser(is, defaultBaseURI, resourceResolver);
            return fopConfParser.getFopFactoryBuilder();
        }
        catch (Exception e) {
            log.error("Can't set up FOP 2.x; " + e.getMessage());
            log.error(e.getMessage(), (Throwable)e);
            throw new FOPException(e.getMessage(), e);
        }
    }

    protected static class FopPlaceholderLookup
    extends AbstractPlaceholderLookup {
        public FopPlaceholderLookup(List<FORenderer.SectionPageInformation> pageNumberInformation) {
            super(pageNumberInformation);
        }

        public void setResults(FormattingResults formattingResults) throws Docx4JException {
            List resultList = null;
            PageSequenceResults pageSequenceResults = null;
            if (formattingResults == null) {
                throw new Docx4JException("Apache fop returned no FormattingResults (null)");
            }
            resultList = formattingResults.getPageSequences();
            if (resultList == null) {
                throw new Docx4JException("Apache fop returned null pageSequences");
            }
            if (resultList.size() != this.pageNumberInformation.size()) {
                throw new Docx4JException("Apache fop returned different count of sections than expected, returned: " + resultList.size() + ", expected: " + this.pageNumberInformation.size());
            }
            this.putDocumentPageCount(formattingResults.getPageCount());
            for (int i = 0; i < formattingResults.getPageSequences().size(); ++i) {
                pageSequenceResults = (PageSequenceResults)resultList.get(i);
                this.putSectionPageCount(i, pageSequenceResults.getPageCount());
            }
        }
    }
}

