/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.utils;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLResolver;
import org.apache.commons.io.input.UnsynchronizedByteArrayInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaXInputFactoryUtils {
    protected static Logger log = LoggerFactory.getLogger(StaXInputFactoryUtils.class);
    public static final int DEFAULT_MAX_ENTITY_EXPANSIONS = 20;
    private static final String JAXP_ENTITY_EXPANSION_LIMIT_KEY = "jdk.xml.entityExpansionLimit";
    private static final AtomicBoolean HAS_WARNED_STAX = new AtomicBoolean(false);
    private static final AtomicBoolean HAS_WARNED_ACCESS_EXTERNAL_DTD = new AtomicBoolean(false);
    private static final XMLResolver IGNORING_STAX_ENTITY_RESOLVER = (publicID, systemID, baseURI, namespace) -> UnsynchronizedByteArrayInputStream.nullInputStream();
    private static volatile int MAX_ENTITY_EXPANSIONS = StaXInputFactoryUtils.determineMaxEntityExpansions();

    public static XMLInputFactory getXMLInputFactory() {
        XMLInputFactory factory = XMLInputFactory.newFactory();
        if (log.isDebugEnabled()) {
            log.debug("XMLInputFactory class {}", factory.getClass());
        }
        StaXInputFactoryUtils.tryToSetStaxProperty(factory, "javax.xml.stream.isNamespaceAware", true);
        StaXInputFactoryUtils.tryToSetStaxProperty(factory, "http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        StaXInputFactoryUtils.tryToSetStaxProperty(factory, "javax.xml.stream.isValidating", false);
        StaXInputFactoryUtils.tryToSetStaxProperty(factory, "javax.xml.stream.supportDTD", false);
        StaXInputFactoryUtils.tryToSetStaxProperty(factory, "javax.xml.stream.isSupportingExternalEntities", false);
        factory.setXMLResolver(IGNORING_STAX_ENTITY_RESOLVER);
        StaXInputFactoryUtils.trySetStaxSecurityManager(factory);
        return factory;
    }

    private static int determineMaxEntityExpansions() {
        String expansionLimit = System.getProperty(JAXP_ENTITY_EXPANSION_LIMIT_KEY);
        if (expansionLimit != null) {
            try {
                return Integer.parseInt(expansionLimit);
            }
            catch (NumberFormatException e) {
                log.warn("Couldn't parse an integer for the entity expansion limit: {}; backing off to default: {}", (Object)expansionLimit, (Object)20);
            }
        }
        return 20;
    }

    private static void trySetStaxSecurityManager(XMLInputFactory inputFactory) {
        block4: {
            try {
                inputFactory.setProperty("http://www.oracle.com/xml/jaxp/properties/entityExpansionLimit", MAX_ENTITY_EXPANSIONS);
            }
            catch (IllegalArgumentException e) {
                try {
                    inputFactory.setProperty("com.ctc.wstx.maxEntityCount", MAX_ENTITY_EXPANSIONS);
                }
                catch (IllegalArgumentException e2) {
                    if (HAS_WARNED_STAX.getAndSet(true)) break block4;
                    log.warn("Could not set limit on maximum entity expansions for: " + inputFactory.getClass());
                }
            }
        }
    }

    private static void tryToSetStaxProperty(XMLInputFactory factory, String key, boolean value) {
        try {
            factory.setProperty(key, value);
        }
        catch (IllegalArgumentException e) {
            log.warn("StAX Feature unsupported: {}", (Object)key, (Object)e);
        }
    }

    private static void tryToSetStaxProperty(XMLInputFactory factory, String key, String value) {
        try {
            factory.setProperty(key, value);
        }
        catch (IllegalArgumentException e) {
            if (key.equals("http://javax.xml.XMLConstants/property/accessExternalDTD")) {
                if (!HAS_WARNED_ACCESS_EXTERNAL_DTD.getAndSet(true)) {
                    log.warn("StAX Feature unsupported: {}", (Object)key, (Object)e);
                }
            }
            log.warn("StAX Feature unsupported: {}", (Object)key, (Object)e);
        }
    }
}

