/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.reporting.model.io.stax;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.codehaus.mojo.versions.reporting.model.PluginInfo;
import org.codehaus.mojo.versions.reporting.model.PluginReportSummary;
import org.codehaus.mojo.versions.reporting.model.PluginUpdatesReport;
import org.codehaus.mojo.versions.reporting.model.io.stax.IndentingXMLStreamWriter;

public class PluginUpdatesReportStaxWriter {
    private int curId;
    private Map idMap = new HashMap();

    public void write(Writer writer, PluginUpdatesReport pluginUpdatesReport) throws IOException, XMLStreamException {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        boolean supportWindowsLineEndings = false;
        if (factory.isPropertySupported("com.ctc.wstx.outputEscapeCr")) {
            factory.setProperty("com.ctc.wstx.outputEscapeCr", Boolean.FALSE);
            supportWindowsLineEndings = true;
        }
        if (factory.isPropertySupported("org.codehaus.stax2.automaticEmptyElements")) {
            factory.setProperty("org.codehaus.stax2.automaticEmptyElements", Boolean.FALSE);
        }
        IndentingXMLStreamWriter serializer = new IndentingXMLStreamWriter(factory.createXMLStreamWriter(writer));
        if (supportWindowsLineEndings) {
            serializer.setNewLine(serializer.getLineSeparator());
        }
        serializer.writeStartDocument(pluginUpdatesReport.getModelEncoding(), "1.0");
        this.writePluginUpdatesReport(pluginUpdatesReport, "PluginUpdatesReport", serializer);
        serializer.writeEndDocument();
    }

    public void write(OutputStream stream, PluginUpdatesReport pluginUpdatesReport) throws IOException, XMLStreamException {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        boolean supportWindowsLineEndings = false;
        if (factory.isPropertySupported("com.ctc.wstx.outputEscapeCr")) {
            factory.setProperty("com.ctc.wstx.outputEscapeCr", Boolean.FALSE);
            supportWindowsLineEndings = true;
        }
        if (factory.isPropertySupported("org.codehaus.stax2.automaticEmptyElements")) {
            factory.setProperty("org.codehaus.stax2.automaticEmptyElements", Boolean.FALSE);
        }
        IndentingXMLStreamWriter serializer = new IndentingXMLStreamWriter(factory.createXMLStreamWriter(stream, pluginUpdatesReport.getModelEncoding()));
        if (supportWindowsLineEndings) {
            serializer.setNewLine(serializer.getLineSeparator());
        }
        serializer.writeStartDocument(pluginUpdatesReport.getModelEncoding(), "1.0");
        this.writePluginUpdatesReport(pluginUpdatesReport, "PluginUpdatesReport", serializer);
        serializer.writeEndDocument();
    }

    private void writePluginInfo(PluginInfo pluginInfo, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (pluginInfo != null) {
            serializer.writeStartElement(tagName);
            if (pluginInfo.getGroupId() != null) {
                serializer.writeStartElement("groupId");
                serializer.writeCharacters(pluginInfo.getGroupId());
                serializer.writeEndElement();
            }
            if (pluginInfo.getArtifactId() != null) {
                serializer.writeStartElement("artifactId");
                serializer.writeCharacters(pluginInfo.getArtifactId());
                serializer.writeEndElement();
            }
            if (pluginInfo.getScope() != null) {
                serializer.writeStartElement("scope");
                serializer.writeCharacters(pluginInfo.getScope());
                serializer.writeEndElement();
            }
            if (pluginInfo.getClassifier() != null) {
                serializer.writeStartElement("classifier");
                serializer.writeCharacters(pluginInfo.getClassifier());
                serializer.writeEndElement();
            }
            if (pluginInfo.getType() != null) {
                serializer.writeStartElement("type");
                serializer.writeCharacters(pluginInfo.getType());
                serializer.writeEndElement();
            }
            if (pluginInfo.getCurrentVersion() != null) {
                serializer.writeStartElement("currentVersion");
                serializer.writeCharacters(pluginInfo.getCurrentVersion());
                serializer.writeEndElement();
            }
            if (pluginInfo.getLastVersion() != null) {
                serializer.writeStartElement("lastVersion");
                serializer.writeCharacters(pluginInfo.getLastVersion());
                serializer.writeEndElement();
            }
            if (pluginInfo.getAny() != null && pluginInfo.getAny().size() > 0) {
                serializer.writeStartElement("any");
                for (String any : pluginInfo.getAny()) {
                    serializer.writeStartElement("any");
                    serializer.writeCharacters(any);
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            if (pluginInfo.getIncrementals() != null && pluginInfo.getIncrementals().size() > 0) {
                serializer.writeStartElement("incrementals");
                for (String incremental : pluginInfo.getIncrementals()) {
                    serializer.writeStartElement("incremental");
                    serializer.writeCharacters(incremental);
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            if (pluginInfo.getMinors() != null && pluginInfo.getMinors().size() > 0) {
                serializer.writeStartElement("minors");
                for (String minor : pluginInfo.getMinors()) {
                    serializer.writeStartElement("minor");
                    serializer.writeCharacters(minor);
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            if (pluginInfo.getMajors() != null && pluginInfo.getMajors().size() > 0) {
                serializer.writeStartElement("majors");
                for (String major : pluginInfo.getMajors()) {
                    serializer.writeStartElement("major");
                    serializer.writeCharacters(major);
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            if (pluginInfo.getStatus() != null) {
                serializer.writeStartElement("status");
                serializer.writeCharacters(pluginInfo.getStatus());
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }

    private void writePluginReportSummary(PluginReportSummary pluginReportSummary, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (pluginReportSummary != null) {
            serializer.writeStartElement(tagName);
            if (pluginReportSummary.getUsingLastVersion() != null) {
                serializer.writeStartElement("usingLastVersion");
                serializer.writeCharacters(pluginReportSummary.getUsingLastVersion());
                serializer.writeEndElement();
            }
            if (pluginReportSummary.getNextVersionAvailable() != null) {
                serializer.writeStartElement("nextVersionAvailable");
                serializer.writeCharacters(pluginReportSummary.getNextVersionAvailable());
                serializer.writeEndElement();
            }
            if (pluginReportSummary.getNextIncrementalAvailable() != null) {
                serializer.writeStartElement("nextIncrementalAvailable");
                serializer.writeCharacters(pluginReportSummary.getNextIncrementalAvailable());
                serializer.writeEndElement();
            }
            if (pluginReportSummary.getNextMinorAvailable() != null) {
                serializer.writeStartElement("nextMinorAvailable");
                serializer.writeCharacters(pluginReportSummary.getNextMinorAvailable());
                serializer.writeEndElement();
            }
            if (pluginReportSummary.getNextMajorAvailable() != null) {
                serializer.writeStartElement("nextMajorAvailable");
                serializer.writeCharacters(pluginReportSummary.getNextMajorAvailable());
                serializer.writeEndElement();
            }
            if (pluginReportSummary.getDependencyUpdates() != null) {
                serializer.writeStartElement("dependencyUpdates");
                serializer.writeCharacters(pluginReportSummary.getDependencyUpdates());
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }

    private void writePluginUpdatesReport(PluginUpdatesReport pluginUpdatesReport, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (pluginUpdatesReport != null) {
            serializer.setDefaultNamespace("https://www.mojohaus.org/VERSIONS/PLUGIN-UPDATES-REPORT/2.0.0");
            serializer.writeStartElement(tagName);
            serializer.writeDefaultNamespace("https://www.mojohaus.org/VERSIONS/PLUGIN-UPDATES-REPORT/2.0.0");
            serializer.setPrefix("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            serializer.writeNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            serializer.writeAttribute("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation", "https://www.mojohaus.org/VERSIONS/PLUGIN-UPDATES-REPORT/2.0.0 https://www.mojohaus.org/versions/versions-model-report/xsd/plugin-updates-report-2.0.0.xsd");
            if (pluginUpdatesReport.getSummary() != null) {
                this.writePluginReportSummary(pluginUpdatesReport.getSummary(), "summary", serializer);
            }
            if (pluginUpdatesReport.getPluginManagements() != null && pluginUpdatesReport.getPluginManagements().size() > 0) {
                serializer.writeStartElement("pluginManagements");
                for (PluginInfo o : pluginUpdatesReport.getPluginManagements()) {
                    this.writePluginInfo(o, "pluginManagement", serializer);
                }
                serializer.writeEndElement();
            }
            if (pluginUpdatesReport.getPlugins() != null && pluginUpdatesReport.getPlugins().size() > 0) {
                serializer.writeStartElement("plugins");
                for (PluginInfo o : pluginUpdatesReport.getPlugins()) {
                    this.writePluginInfo(o, "plugin", serializer);
                }
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }
}

