/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.filtering;

import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.maven.model.Dependency;
import org.codehaus.mojo.versions.filtering.NullAwareWildcardMatcher;
import org.codehaus.mojo.versions.filtering.WildcardMatcher;

public class TokenizedMatcher
implements Predicate<Dependency> {
    private final Map<Tokens, Predicate<String>> matchers;

    private TokenizedMatcher(Map<Tokens, Predicate<String>> matchers) {
        this.matchers = matchers;
    }

    @Override
    public boolean test(Dependency dependency) {
        for (Tokens token : Tokens.values()) {
            String tokenValue = token.getTokenExtractor().apply(dependency);
            Predicate<String> matcher = this.matchers.get((Object)token);
            boolean matches = matcher.test(tokenValue);
            if (matches) continue;
            return false;
        }
        return true;
    }

    public static TokenizedMatcher parse(String pattern) {
        EnumMap<Tokens, WildcardMatcher> matchers = new EnumMap<Tokens, WildcardMatcher>(Tokens.class);
        String[] split = pattern == null ? new String[]{} : pattern.split(":");
        String groupIdPattern = split.length >= 1 ? split[0] : "*";
        matchers.put(Tokens.GROUP_ID, WildcardMatcher.parse(groupIdPattern));
        String artifactIdPattern = split.length >= 2 ? split[1] : "*";
        matchers.put(Tokens.ARTIFACT_ID, WildcardMatcher.parse(artifactIdPattern));
        String versionPattern = split.length >= 3 ? split[2] : "*";
        matchers.put(Tokens.VERSION, WildcardMatcher.parse(versionPattern));
        String typePattern = split.length >= 4 ? split[3] : "*";
        matchers.put(Tokens.TYPE, WildcardMatcher.parse(typePattern));
        String classifierPattern = split.length >= 5 ? split[4] : "*";
        matchers.put(Tokens.CLASSIFIER, new NullAwareWildcardMatcher(classifierPattern));
        String scopePattern = split.length >= 6 ? split[5] : "*";
        matchers.put(Tokens.SCOPE, new NullAwareWildcardMatcher(scopePattern));
        return new TokenizedMatcher(Collections.unmodifiableMap(matchers));
    }

    public String toString() {
        return String.format("%s{%s}", this.getClass().getSimpleName(), this.matchers);
    }

    public static enum Tokens {
        GROUP_ID(Dependency::getGroupId),
        ARTIFACT_ID(Dependency::getArtifactId),
        VERSION(Dependency::getVersion),
        TYPE(Dependency::getType),
        CLASSIFIER(Dependency::getClassifier),
        SCOPE(Dependency::getScope);

        private final Function<Dependency, String> tokenExtractor;

        private Tokens(Function<Dependency, String> tokenExtractor) {
            this.tokenExtractor = tokenExtractor;
        }

        public Function<Dependency, String> getTokenExtractor() {
            return this.tokenExtractor;
        }
    }
}

