/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.rule;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.mojo.versions.api.IgnoreVersionHelper;
import org.codehaus.mojo.versions.model.IgnoreVersion;
import org.codehaus.mojo.versions.model.Rule;
import org.codehaus.mojo.versions.model.RuleSet;
import org.codehaus.mojo.versions.utils.RegexUtils;

public class RuleService {
    Log log;
    private final Map<String, Rule> bestFitRuleCache = new ConcurrentHashMap<String, Rule>();
    private final RuleSet ruleSet;

    public RuleService(Log log, RuleSet ruleSet) {
        this.log = log;
        this.ruleSet = ruleSet;
    }

    public Rule getBestFitRule(String groupId, String artifactId) {
        String groupArtifactId = groupId + ':' + artifactId;
        if (this.bestFitRuleCache.containsKey(groupArtifactId)) {
            return this.bestFitRuleCache.get(groupArtifactId);
        }
        Rule bestFit = null;
        List rules = this.getRuleSet().getRules();
        int bestGroupIdScore = Integer.MAX_VALUE;
        int bestArtifactIdScore = Integer.MAX_VALUE;
        boolean exactGroupId = false;
        boolean exactArtifactId = false;
        for (Rule rule : rules) {
            int artifactIdScore;
            boolean exactMatch;
            boolean match;
            int groupIdScore = RegexUtils.getWildcardScore(rule.getGroupId());
            if (groupIdScore > bestGroupIdScore || !(match = (exactMatch = RuleService.exactMatch(rule.getGroupId(), groupId)) || RuleService.match(rule.getGroupId(), groupId)) || exactGroupId && !exactMatch) continue;
            if (bestGroupIdScore > groupIdScore) {
                bestArtifactIdScore = Integer.MAX_VALUE;
                exactArtifactId = false;
            }
            bestGroupIdScore = groupIdScore;
            if (exactMatch && !exactGroupId) {
                exactGroupId = true;
                bestArtifactIdScore = Integer.MAX_VALUE;
                exactArtifactId = false;
            }
            if ((artifactIdScore = RegexUtils.getWildcardScore(rule.getArtifactId())) > bestArtifactIdScore || !(match = (exactMatch = RuleService.exactMatch(rule.getArtifactId(), artifactId)) || RuleService.match(rule.getArtifactId(), artifactId)) || exactArtifactId && !exactMatch) continue;
            bestArtifactIdScore = artifactIdScore;
            if (exactMatch && !exactArtifactId) {
                exactArtifactId = true;
            }
            bestFit = rule;
        }
        if (bestFit != null) {
            this.bestFitRuleCache.put(groupArtifactId, bestFit);
        }
        return bestFit;
    }

    public List<IgnoreVersion> getIgnoredVersions(Artifact artifact) {
        Rule bestFitRule = this.getBestFitRule(artifact.getGroupId(), artifact.getArtifactId());
        return Stream.concat(this.ruleSet.getIgnoreVersions().stream(), Optional.ofNullable(bestFitRule).map(Rule::getIgnoreVersions).map(Collection::stream).orElse(Stream.empty())).filter(v -> {
            if (!IgnoreVersionHelper.isValidType(v)) {
                this.log.warn((CharSequence)("The type attribute '" + v.getType() + "' for global ignoreVersion[" + v + "] is not valid. Please use one of '" + IgnoreVersionHelper.VALID_TYPES + "'."));
                return false;
            }
            return true;
        }).collect(Collectors.toList());
    }

    public RuleSet getRuleSet() {
        return this.ruleSet;
    }

    static boolean exactMatch(String wildcardRule, String value) {
        Pattern p = Pattern.compile(RegexUtils.convertWildcardsToRegex(wildcardRule, true));
        return p.matcher(value).matches();
    }

    static boolean match(String wildcardRule, String value) {
        Pattern p = Pattern.compile(RegexUtils.convertWildcardsToRegex(wildcardRule, false));
        return p.matcher(value).matches();
    }
}

