/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.invoker;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.plugins.invoker.PomUtils;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.ProjectArtifact;
import org.eclipse.aether.DefaultRepositoryCache;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositoryCache;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.ArtifactType;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.DefaultDependencyNode;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.installation.InstallRequest;
import org.eclipse.aether.installation.InstallationException;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.util.artifact.ArtifactIdUtils;
import org.eclipse.aether.util.artifact.SubArtifact;
import org.eclipse.aether.util.filter.DependencyFilterUtils;

@Mojo(name="install", defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class InstallMojo
extends AbstractMojo {
    @Component
    private RepositorySystem repositorySystem;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(property="invoker.localRepositoryPath", defaultValue="${session.localRepository.basedir}", required=true)
    private File localRepositoryPath;
    @Parameter(property="invoker.skip", defaultValue="false")
    private boolean skipInstallation;
    @Parameter
    private String[] extraArtifacts;
    @Parameter(property="invoker.install.scope", defaultValue="runtime")
    private String scope;

    public void execute() throws MojoExecutionException {
        if (this.skipInstallation) {
            this.getLog().info((CharSequence)"Skipping artifact installation per configuration.");
            return;
        }
        LinkedHashMap<String, org.eclipse.aether.artifact.Artifact> resolvedArtifacts = new LinkedHashMap<String, org.eclipse.aether.artifact.Artifact>();
        try {
            this.resolveProjectArtifacts(resolvedArtifacts);
            this.resolveProjectPoms(this.project, resolvedArtifacts);
            this.resolveProjectDependencies(resolvedArtifacts);
            this.resolveExtraArtifacts(resolvedArtifacts);
            this.installArtifacts(resolvedArtifacts);
        }
        catch (InstallationException | ArtifactResolutionException | DependencyResolutionException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private void resolveProjectArtifacts(Map<String, org.eclipse.aether.artifact.Artifact> resolvedArtifacts) {
        if (this.project.getArtifact() != null && this.project.getArtifact().getFile() != null) {
            org.eclipse.aether.artifact.Artifact artifact = RepositoryUtils.toArtifact((Artifact)this.project.getArtifact());
            resolvedArtifacts.put(ArtifactIdUtils.toId((org.eclipse.aether.artifact.Artifact)artifact), artifact);
        }
        this.project.getAttachedArtifacts().stream().map(RepositoryUtils::toArtifact).forEach(a -> resolvedArtifacts.put(ArtifactIdUtils.toId((org.eclipse.aether.artifact.Artifact)a), (org.eclipse.aether.artifact.Artifact)a));
    }

    private void resolveProjectPoms(MavenProject project, Map<String, org.eclipse.aether.artifact.Artifact> resolvedArtifacts) throws ArtifactResolutionException {
        if (project == null) {
            return;
        }
        org.eclipse.aether.artifact.Artifact projectPom = RepositoryUtils.toArtifact((Artifact)new ProjectArtifact(project));
        if (projectPom.getFile() != null) {
            resolvedArtifacts.put(projectPom.toString(), projectPom);
        } else {
            org.eclipse.aether.artifact.Artifact artifact = this.resolveArtifact(projectPom, project.getRemoteProjectRepositories());
            resolvedArtifacts.put(ArtifactIdUtils.toId((org.eclipse.aether.artifact.Artifact)artifact), artifact);
        }
        this.resolveProjectPoms(project.getParent(), resolvedArtifacts);
    }

    private void resolveProjectDependencies(Map<String, org.eclipse.aether.artifact.Artifact> resolvedArtifacts) throws ArtifactResolutionException, MojoExecutionException, DependencyResolutionException {
        DependencyFilter classpathFilter = DependencyFilterUtils.classpathFilter((String[])new String[]{this.scope});
        ArtifactTypeRegistry artifactTypeRegistry = this.session.getRepositorySession().getArtifactTypeRegistry();
        List managedDependencies = Optional.ofNullable(this.project.getDependencyManagement()).map(DependencyManagement::getDependencies).orElseGet(Collections::emptyList).stream().map(d -> RepositoryUtils.toDependency((Dependency)d, (ArtifactTypeRegistry)artifactTypeRegistry)).collect(Collectors.toList());
        List dependencies = this.project.getDependencies().stream().map(d -> RepositoryUtils.toDependency((Dependency)d, (ArtifactTypeRegistry)artifactTypeRegistry)).filter(d -> classpathFilter.accept((DependencyNode)new DefaultDependencyNode(d), null)).collect(Collectors.toList());
        CollectRequest collectRequest = new CollectRequest();
        collectRequest.setRootArtifact(RepositoryUtils.toArtifact((Artifact)this.project.getArtifact()));
        collectRequest.setDependencies(dependencies);
        collectRequest.setManagedDependencies(managedDependencies);
        collectRequest.setRepositories(this.project.getRemoteProjectRepositories());
        DependencyRequest request = new DependencyRequest(collectRequest, classpathFilter);
        DependencyResult dependencyResult = this.repositorySystem.resolveDependencies(this.session.getRepositorySession(), request);
        List<org.eclipse.aether.artifact.Artifact> artifacts = dependencyResult.getArtifactResults().stream().map(ArtifactResult::getArtifact).collect(Collectors.toList());
        artifacts.forEach(a -> resolvedArtifacts.put(ArtifactIdUtils.toId((org.eclipse.aether.artifact.Artifact)a), (org.eclipse.aether.artifact.Artifact)a));
        this.resolvePomsForArtifacts(artifacts, resolvedArtifacts, collectRequest.getRepositories());
    }

    private void resolveExtraArtifacts(Map<String, org.eclipse.aether.artifact.Artifact> resolvedArtifacts) throws MojoExecutionException, DependencyResolutionException, ArtifactResolutionException {
        if (this.extraArtifacts == null) {
            return;
        }
        DependencyFilter classpathFilter = DependencyFilterUtils.classpathFilter((String[])new String[]{"runtime"});
        for (String extraArtifact : this.extraArtifacts) {
            ArtifactType artifactType;
            String[] gav = extraArtifact.split(":");
            if (gav.length < 3 || gav.length > 5) {
                throw new MojoExecutionException("Invalid artifact " + extraArtifact);
            }
            String groupId = gav[0];
            String artifactId = gav[1];
            String version = gav[2];
            String type = "jar";
            if (gav.length > 3) {
                type = gav[3];
            }
            String classifier = null;
            if (gav.length == 5) {
                classifier = gav[4];
            }
            List remoteRepositories = (artifactType = this.session.getRepositorySession().getArtifactTypeRegistry().get(type)) != null && "maven-plugin".equals(artifactType.getId()) ? this.project.getRemotePluginRepositories() : this.project.getRemoteProjectRepositories();
            DefaultArtifact artifact = new DefaultArtifact(groupId, artifactId, classifier, null, version, artifactType);
            this.resolvePomsForArtifacts(Collections.singletonList(artifact), resolvedArtifacts, remoteRepositories);
            CollectRequest collectRequest = new CollectRequest();
            org.eclipse.aether.graph.Dependency root = new org.eclipse.aether.graph.Dependency((org.eclipse.aether.artifact.Artifact)artifact, "compile");
            collectRequest.setRoot(root);
            collectRequest.setRepositories(remoteRepositories);
            DependencyRequest request = new DependencyRequest(collectRequest, classpathFilter);
            DependencyResult dependencyResult = this.repositorySystem.resolveDependencies(this.session.getRepositorySession(), request);
            List<org.eclipse.aether.artifact.Artifact> artifacts = dependencyResult.getArtifactResults().stream().map(ArtifactResult::getArtifact).collect(Collectors.toList());
            artifacts.forEach(a -> resolvedArtifacts.put(ArtifactIdUtils.toId((org.eclipse.aether.artifact.Artifact)a), (org.eclipse.aether.artifact.Artifact)a));
            this.resolvePomsForArtifacts(artifacts, resolvedArtifacts, collectRequest.getRepositories());
        }
    }

    private void resolvePomsForArtifacts(List<org.eclipse.aether.artifact.Artifact> artifacts, Map<String, org.eclipse.aether.artifact.Artifact> resolvedArtifacts, List<RemoteRepository> remoteRepositories) throws ArtifactResolutionException, MojoExecutionException {
        for (org.eclipse.aether.artifact.Artifact a : artifacts) {
            org.eclipse.aether.artifact.Artifact artifactResult = this.resolveArtifact((org.eclipse.aether.artifact.Artifact)new SubArtifact(a, "", "pom"), remoteRepositories);
            this.resolvePomWithParents(artifactResult, resolvedArtifacts, remoteRepositories);
        }
    }

    private void resolvePomWithParents(org.eclipse.aether.artifact.Artifact artifact, Map<String, org.eclipse.aether.artifact.Artifact> resolvedArtifacts, List<RemoteRepository> remoteRepositories) throws MojoExecutionException, ArtifactResolutionException {
        if (resolvedArtifacts.containsKey(ArtifactIdUtils.toId((org.eclipse.aether.artifact.Artifact)artifact))) {
            return;
        }
        Model model = PomUtils.loadPom(artifact.getFile());
        Parent parent = model.getParent();
        if (parent != null) {
            DefaultArtifact pom = new DefaultArtifact(parent.getGroupId(), parent.getArtifactId(), "", "pom", parent.getVersion());
            org.eclipse.aether.artifact.Artifact resolvedPom = this.resolveArtifact((org.eclipse.aether.artifact.Artifact)pom, remoteRepositories);
            this.resolvePomWithParents(resolvedPom, resolvedArtifacts, remoteRepositories);
        }
        resolvedArtifacts.put(ArtifactIdUtils.toId((org.eclipse.aether.artifact.Artifact)artifact), artifact);
    }

    private org.eclipse.aether.artifact.Artifact resolveArtifact(org.eclipse.aether.artifact.Artifact artifact, List<RemoteRepository> remoteRepositories) throws ArtifactResolutionException {
        ArtifactRequest request = new ArtifactRequest();
        request.setArtifact(artifact);
        request.setRepositories(remoteRepositories);
        ArtifactResult artifactResult = this.repositorySystem.resolveArtifact(this.session.getRepositorySession(), request);
        return artifactResult.getArtifact();
    }

    private void installArtifacts(Map<String, org.eclipse.aether.artifact.Artifact> resolvedArtifacts) throws InstallationException {
        RepositorySystemSession systemSessionForLocalRepo = this.createSystemSessionForLocalRepo();
        Map collect = resolvedArtifacts.values().stream().filter(a -> !this.hasTheSamePathAsTarget((org.eclipse.aether.artifact.Artifact)a, systemSessionForLocalRepo)).collect(Collectors.groupingBy(a -> String.format("%s:%s:%s", a.getGroupId(), a.getArtifactId(), a.getVersion()), LinkedHashMap::new, Collectors.toList()));
        for (List artifacts : collect.values()) {
            InstallRequest request = new InstallRequest();
            request.setArtifacts((Collection)artifacts);
            this.repositorySystem.install(systemSessionForLocalRepo, request);
        }
    }

    private boolean hasTheSamePathAsTarget(org.eclipse.aether.artifact.Artifact artifact, RepositorySystemSession systemSession) {
        try {
            File sourceFile;
            LocalRepositoryManager lrm = systemSession.getLocalRepositoryManager();
            File targetBasedir = lrm.getRepository().getBasedir();
            if (targetBasedir == null) {
                return false;
            }
            File targetFile = new File(targetBasedir, lrm.getPathForLocalArtifact(artifact)).getCanonicalFile();
            if (Objects.equals(targetFile, sourceFile = artifact.getFile().getCanonicalFile())) {
                this.getLog().debug((CharSequence)("Skip install the same target " + sourceFile));
                return true;
            }
            return false;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private RepositorySystemSession createSystemSessionForLocalRepo() {
        RepositorySystemSession repositorySystemSession = this.session.getRepositorySession();
        if (this.localRepositoryPath != null) {
            DefaultRepositorySystemSession newSession = new DefaultRepositorySystemSession(this.session.getRepositorySession());
            newSession.setCache((RepositoryCache)new DefaultRepositoryCache());
            String contentType = newSession.getLocalRepository().getContentType();
            if ("enhanced".equals(contentType)) {
                contentType = "default";
            }
            LocalRepositoryManager localRepositoryManager = this.repositorySystem.newLocalRepositoryManager((RepositorySystemSession)newSession, new LocalRepository(this.localRepositoryPath, contentType));
            newSession.setLocalRepositoryManager(localRepositoryManager);
            repositorySystemSession = newSession;
            this.getLog().debug((CharSequence)("localRepoPath: " + localRepositoryManager.getRepository().getBasedir()));
        }
        return repositorySystemSession;
    }
}

