/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.iter;

import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.om.FocusIterator;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.GroundedIterator;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.tree.iter.ReversibleIterator;
import net.sf.saxon.tree.iter.UnfailingIterator;

public class ManualIterator<T extends Item<?>>
implements FocusIterator<T>,
UnfailingIterator<T>,
ReversibleIterator<T>,
LastPositionFinder,
GroundedIterator<T>,
LookaheadIterator<T> {
    private T item;
    private int position;
    private LastPositionFinder lastPositionFinder;

    public ManualIterator() {
        this.item = null;
        this.position = 0;
    }

    public ManualIterator(T value, int position) {
        this.item = value;
        this.position = position;
    }

    public ManualIterator(T value) {
        this.item = value;
        this.position = 1;
        this.lastPositionFinder = () -> 1;
    }

    public void setContextItem(T value) {
        this.item = value;
    }

    public void setLastPositionFinder(LastPositionFinder finder) {
        this.lastPositionFinder = finder;
    }

    public void incrementPosition() {
        ++this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    @Override
    public boolean hasNext() {
        try {
            return this.position() != this.getLength();
        }
        catch (XPathException e) {
            return false;
        }
    }

    @Override
    public T next() {
        return null;
    }

    @Override
    public T current() {
        return this.item;
    }

    @Override
    public int position() {
        return this.position;
    }

    @Override
    public int getLength() throws XPathException {
        if (this.lastPositionFinder == null) {
            throw new XPathException("Saxon streaming restriction: last() cannot be used when consuming a sequence of streamed nodes, even if the items being processed are grounded");
        }
        return this.lastPositionFinder.getLength();
    }

    @Override
    public void close() {
    }

    @Override
    public ManualIterator<T> getReverseIterator() {
        return new ManualIterator<T>(this.item);
    }

    @Override
    public GroundedValue<T> materialize() {
        return this.item;
    }

    @Override
    public GroundedValue<T> getResidue() {
        return this.materialize();
    }

    @Override
    public int getProperties() {
        return 7;
    }
}

