/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import javax.xml.transform.Source;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.Genre;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Untyped;

public interface NodeInfo
extends Source,
Item<NodeInfo>,
Location {
    public static final int IS_DTD_TYPE = 0x40000000;
    public static final int IS_NILLED = 0x20000000;

    public TreeInfo getTreeInfo();

    default public Configuration getConfiguration() {
        return this.getTreeInfo().getConfiguration();
    }

    public int getNodeKind();

    default public boolean isSameNodeInfo(NodeInfo other) {
        return this.equals(other);
    }

    public boolean equals(Object var1);

    public int hashCode();

    @Override
    public String getSystemId();

    @Override
    default public String getPublicId() {
        return null;
    }

    public String getBaseURI();

    @Override
    default public int getLineNumber() {
        return -1;
    }

    @Override
    default public int getColumnNumber() {
        return -1;
    }

    public int compareOrder(NodeInfo var1);

    @Override
    public String getStringValue();

    public boolean hasFingerprint();

    public int getFingerprint();

    public String getLocalPart();

    public String getURI();

    public String getDisplayName();

    public String getPrefix();

    default public SchemaType getSchemaType() {
        switch (this.getNodeKind()) {
            case 2: {
                return BuiltInAtomicType.UNTYPED_ATOMIC;
            }
            case 1: 
            case 9: {
                return Untyped.getInstance();
            }
        }
        return null;
    }

    @Override
    public AtomicSequence atomize() throws XPathException;

    public NodeInfo getParent();

    default public AxisIterator iterateAxis(byte axisNumber) {
        return this.iterateAxis(axisNumber, AnyNodeTest.getInstance());
    }

    public AxisIterator iterateAxis(byte var1, NodeTest var2);

    public String getAttributeValue(String var1, String var2);

    public NodeInfo getRoot();

    public boolean hasChildNodes();

    public void generateId(FastStringBuffer var1);

    default public void copy(Receiver out, int copyOptions, Location locationId) throws XPathException {
        Navigator.copy(this, out, copyOptions, locationId);
    }

    public NamespaceBinding[] getDeclaredNamespaces(NamespaceBinding[] var1);

    default public boolean isId() {
        return false;
    }

    default public boolean isIdref() {
        return false;
    }

    default public boolean isNilled() {
        return false;
    }

    @Override
    default public boolean isStreamed() {
        return false;
    }

    @Override
    default public String toShortString() {
        switch (this.getNodeKind()) {
            case 9: {
                return "document-node()";
            }
            case 1: {
                return "<" + this.getDisplayName() + "/>";
            }
            case 2: {
                return "@" + this.getDisplayName();
            }
            case 3: {
                return "text(\"" + Err.truncate30(this.getStringValue()) + "\")";
            }
            case 8: {
                return "<!--" + Err.truncate30(this.getStringValue()) + "-->";
            }
            case 7: {
                return "<?" + this.getDisplayName() + "?>";
            }
            case 13: {
                String prefix = this.getLocalPart();
                return "xmlns" + (prefix.equals("") ? "" : ":" + prefix) + "=\"" + this.getStringValue() + '\"';
            }
        }
        return "";
    }

    @Override
    default public Genre getGenre() {
        return Genre.NODE;
    }
}

