package live.attach.ui.view.common;

import android.content.Context;
import android.graphics.Color;
import android.support.v7.widget.AppCompatImageView;
import android.util.AttributeSet;
import android.view.View;

public class ToggleIconView extends AppCompatImageView {
    private int state1;
    private int state2;

    private View.OnClickListener state1Listener;
    private View.OnClickListener state2Listener;

    public ToggleIconView(Context context) {
        super(context);
        init();
    }

    public ToggleIconView(Context context, AttributeSet attrs) {
        super(context, attrs);
        init();
    }

    public ToggleIconView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init();
    }

    private void init() {
        setOnClickListener(view -> {
            String currentState = (String) getTag();
            if ("state1".equals(currentState)) {
                setState2();
                if(state2Listener != null) state2Listener.onClick(view);
            } else {
                setState1();
                if(state1Listener != null) state1Listener.onClick(view);
            }
        });
        setColorFilter(Color.BLACK);
    }

    public void setStates(int state1, int state2) {
        this.state1 = state1;
        this.state2 = state2;
        setState1();
    }

    public void setStateListeners(View.OnClickListener state1Listener, View.OnClickListener state2Listener) {
        this.state1Listener = state1Listener;
        this.state2Listener = state2Listener;
    }

    private void setState1() {
        setTag("state1");
        setImageResource(state1);
    }

    private void setState2() {
        setTag("state2");
        setImageResource(state2);
    }
}
