package live.attach.ui.view.common;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;

import live.attach.sdk.R;
import live.attach.domain.model.participant.Participant;
import live.attach.ui.ViewUtils;
import live.attach.ui.view.AttachBrandedView;

public class ParticipantView extends AttachBrandedView {
    private AttachUserImageView participantImageView;
    private View participantStatus;

    public ParticipantView(Context context) {
        super(context);
        init(context, null);
    }

    public ParticipantView(Context context, AttributeSet attrs) {
        super(context, attrs);
        init(context, attrs);
    }

    public ParticipantView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init(context, attrs);
    }

    @TargetApi(Build.VERSION_CODES.LOLLIPOP)
    public ParticipantView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        View root = inflate(getContext(), R.layout.view_participant, this);
        participantImageView = root.findViewById(R.id.userPreview);
        participantStatus = root.findViewById(R.id.userStatus);
    }

    private void setStatus() {
        GradientDrawable backgroundShape = (GradientDrawable) this.participantStatus.getBackground();
        int color = Color.TRANSPARENT;
        backgroundShape.setColor(color);
    }

    private void loadProfilePicture(String url) {
        ViewUtils.loadAvatar(this.getContext(), url, participantImageView.imageView());
    }

    public void setParticipant(Participant participant) {
        loadProfilePicture(participant.getAvatar());
    }
}
