package live.attach.ui.view.common;

import android.content.Context;
import android.util.AttributeSet;

import live.attach.sdk.R;
import live.attach.domain.model.application.AttachProperties;
import live.attach.ui.view.AttachBrandedView;
import live.attach.ui.view.common.roundedimageview.RoundedImageView;

public class AttachUserImageView extends AttachBrandedView {
    public AttachUserImageView(Context context) {
        super(context);
        init();
    }

    public AttachUserImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        init();
    }

    public AttachUserImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        init();
    }

    private void init() {
        inflate(getContext(), R.layout.view_attach_user_image, this);
    }

    public RoundedImageView imageView() {
        return (RoundedImageView) getChildAt(0);
    }

    @Override
    protected void applyBranding(AttachProperties attachProperties) {
        post(() -> {
            float currentRadius = imageView().getCornerRadius();
            float nextBorderRadius = attachProperties.getParticipantsAvatarBorderRadius().getValue();
            nextBorderRadius = (getWidth() / 2) * nextBorderRadius;

            if (currentRadius != nextBorderRadius) {
                imageView().setCornerRadius(nextBorderRadius);
            }
        });
    }
}
