package live.attach.ui.view.common;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.RequiresApi;
import android.util.AttributeSet;
import android.widget.RelativeLayout;

import live.attach.sdk.R;

public class AttachLogoView extends RelativeLayout {
    public AttachLogoView(Context context) {
        super(context);
        init();
    }

    public AttachLogoView(Context context, AttributeSet attrs) {
        super(context, attrs);
        init();
    }

    public AttachLogoView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init();
    }

    @RequiresApi(api = Build.VERSION_CODES.LOLLIPOP)
    public AttachLogoView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        init();
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();

    }

    public void show() {
        setVisibility(VISIBLE);
        postDelayed(() -> setVisibility(INVISIBLE), 3000);
    }

    private void init() {
        inflate(getContext(), R.layout.view_attach_logo, this);
        setOnClickListener(view -> {
            String url = "https://attach.live";
            Intent i = new Intent(Intent.ACTION_VIEW);
            i.setData(Uri.parse(url));
            getContext().startActivity(i);
        });
    }
}
