package live.attach.ui.view;

import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.util.AttributeSet;
import android.view.View;
import android.widget.RelativeLayout;

import live.attach.repackaged.io.reactivex.disposables.Disposable;
import live.attach.lib.live.attach.repackaged.io.reactivex.android.schedulers.AndroidSchedulers;
import live.attach.sdk.AttachActivity;
import live.attach.sdk.AttachSdkInternal;
import live.attach.domain.model.application.AttachProperties;

public class AttachBrandedView extends RelativeLayout {
    private AttachSdkInternal attachSdkInternal;
    private Disposable brandingSubscription;
    private AttachProperties attachProperties;

    public AttachBrandedView(Context context) {
        super(context);
        init();
    }

    public AttachBrandedView(Context context, AttributeSet attrs) {
        super(context, attrs);
        init();
    }

    public AttachBrandedView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init();
    }

    @RequiresApi(api = Build.VERSION_CODES.LOLLIPOP)
    public AttachBrandedView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        init();
    }

    private void init() {
        attachSdkInternal = (AttachSdkInternal) getAttachActivity().getAttachSdk();
    }

    protected final AttachProperties getDefaultStyles() {
        return getAttachActivity().getDefaultProperties();
    }

    protected void applyBranding(AttachProperties attachProperties) {
        // Ignore
    }

    @Override
    protected void onVisibilityChanged(@NonNull View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        if (visibility == VISIBLE && attachProperties != null) {
            applyBranding(attachProperties);
        }
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        brandingSubscription = attachSdkInternal
            .getAttachProperties()
            .observeOn(AndroidSchedulers.mainThread())
            .subscribe(properties -> {
                applyBranding(properties);
                attachProperties = properties;
            });
    }

    @Override
    protected void onDetachedFromWindow() {
        brandingSubscription.dispose();
        super.onDetachedFromWindow();
    }

    protected AttachActivity getAttachActivity() {
        if (getContext() instanceof AttachActivity) {
            return (AttachActivity) getContext();
        } else {
            throw new RuntimeException("Attach views should be in AttachActivity");
        }
    }
}
