package live.attach.ui.roomactivity.video;

import android.content.Context;
import android.os.Build;
import android.support.annotation.RequiresApi;
import android.util.AttributeSet;
import android.view.View;

import live.attach.sdk.R;
import live.attach.ui.view.AttachBrandedView;
import live.attach.ui.view.common.AttachLogoView;

public class VideoOverlayView extends AttachBrandedView {
    private View switchVideo;
    private AttachLogoView attachLogoView;

    public VideoOverlayView(Context context) {
        super(context);
        init();
    }

    public VideoOverlayView(Context context, AttributeSet attrs) {
        super(context, attrs);
        init();
    }

    public VideoOverlayView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init();
    }

    @RequiresApi(api = Build.VERSION_CODES.LOLLIPOP)
    public VideoOverlayView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        init();
    }

    private void init() {
        setClickable(true);
        setFocusable(true);
        View root = inflate(getContext(), R.layout.roomactivity_video_overlay, this);
        switchVideo = root.findViewById(R.id.switchVideoButton);
        attachLogoView = root.findViewById(R.id.videoOverlay_attachLogo);
    }

    public void setSwitchVideoClickListener(OnClickListener listener) {
        switchVideo.setOnClickListener(listener);
    }

    public void showLogo() {
        attachLogoView.show();
    }
}
