package live.attach.ui.roomactivity.video;

import android.content.Context;
import android.graphics.Color;
import android.os.Build;
import android.support.annotation.RequiresApi;
import android.util.AttributeSet;
import android.view.View;
import android.widget.TextView;

import org.webrtc.SurfaceViewRenderer;

import live.attach.sdk.R;
import live.attach.domain.model.application.AttachProperties;
import live.attach.domain.model.participant.Participant;
import live.attach.ui.view.AttachBrandedView;
import live.attach.lib.TextUtils;

public class RemoteVideoView extends AttachBrandedView {
    private TextView userStatus;
    private TextView userName;
    private View dismissButton;
    private View container;
    private SurfaceViewRenderer videoRemote;

    public RemoteVideoView(Context context) {
        super(context);
        init();
    }

    public RemoteVideoView(Context context, AttributeSet attrs) {
        super(context, attrs);
        init();
    }

    public RemoteVideoView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init();
    }

    @RequiresApi(api = Build.VERSION_CODES.LOLLIPOP)
    public RemoteVideoView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        init();
    }

    private void init() {
        View root = inflate(getContext(), R.layout.roomactivity_remote_video_view, this);
        userName = root.findViewById(R.id.remoteVideo_userName);
        userStatus = root.findViewById(R.id.remoteVideo_userStatus);
        dismissButton = root.findViewById(R.id.remoteVideo_dismissButton);
        videoRemote = root.findViewById(R.id.videoRemote);
        container = root.findViewById(R.id.remoteVideo_container);
    }

    @Override
    protected void applyBranding(AttachProperties attachProperties) {
        container.setBackgroundColor(
            Color.parseColor(attachProperties.getVideocallFocusBackgroundColor().value)
        );
        dismissButton.setBackgroundColor(
            Color.parseColor(attachProperties.getVideocallButtonBackgroundColor().value)
        );
    }

    public SurfaceViewRenderer getSurfaceRenderer() {
        return videoRemote;
    }

    public void setOnDismissCallClickListener(View.OnClickListener listener) {
        dismissButton.setOnClickListener(listener);
    }

    public void setParticipant(Participant participant) {
        userStatus.setText(R.string.SDK_CALL_IN_PROGRESS);
        if (TextUtils.isEmpty(participant.getUsername())) {
            userName.setText(R.string.SDK_SOMEBODY);
        } else {
            userName.setText(participant.getUsername());
        }
    }
}
