package live.attach.ui.roomactivity.video;

import android.content.Context;
import android.os.Build;
import android.support.annotation.RequiresApi;
import android.util.AttributeSet;
import android.view.View;

import live.attach.sdk.AttachOverlayActivity;
import live.attach.sdk.R;
import live.attach.ui.view.AttachBrandedView;

public class CameraPermissionsView extends AttachBrandedView {
    private View askPermissionsButton;

    public CameraPermissionsView(Context context) {
        super(context);
        init();
    }

    public CameraPermissionsView(Context context, AttributeSet attrs) {
        super(context, attrs);
        init();
    }

    public CameraPermissionsView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init();
    }

    @RequiresApi(api = Build.VERSION_CODES.LOLLIPOP)
    public CameraPermissionsView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        init();
    }

    private void init() {
        View root = inflate(getContext(), R.layout.roomactivity_camera_permissions, this);
        setBackgroundResource(R.color.attachColorPrimary);
        askPermissionsButton = root.findViewById(R.id.grantPermissionsButton);

        if (((AttachOverlayActivity) getAttachActivity()).hasAttachPermissions()) {
            setVisibility(GONE);
        }
    }

    public void setGrantPermissionListener(View.OnClickListener listener) {
        askPermissionsButton.setOnClickListener(listener);
    }
}
