package live.attach.ui.roomactivity.participant.single;

import android.content.Context;
import android.os.Build;
import android.support.annotation.RequiresApi;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

import live.attach.lib.com.devs.vectorchildfinder.VectorChildFinder;
import live.attach.lib.com.devs.vectorchildfinder.VectorDrawableCompat;
import live.attach.sdk.R;
import live.attach.domain.model.application.AttachProperties;
import live.attach.domain.model.application.Color;
import live.attach.domain.model.participant.Participant;
import live.attach.ui.roomactivity.participant.OnParticipantClickListener;
import live.attach.ui.view.AttachBrandedView;
import live.attach.ui.view.common.ParticipantView;
import live.attach.lib.TextUtils;

public class SingleParticipantView extends AttachBrandedView {
    ParticipantView participantView;
    TextView userStatus;
    TextView userName;
    ImageView callButton;
    View container;

    Participant participant;

    public SingleParticipantView(Context context) {
        super(context);
        init();
    }

    public SingleParticipantView(Context context, AttributeSet attrs) {
        super(context, attrs);
        init();
    }

    public SingleParticipantView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init();
    }

    @RequiresApi(api = Build.VERSION_CODES.LOLLIPOP)
    public SingleParticipantView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        init();
    }

    private void init() {
        View root = inflate(getContext(), R.layout.roomactivity_single_participant, this);
        participantView = root.findViewById(R.id.singleParticipant_participant);
        userStatus = root.findViewById(R.id.singleParticipant_userStatus);
        userName = root.findViewById(R.id.singleParticipant_userName);
        callButton = root.findViewById(R.id.callButton);
        container = root.findViewById(R.id.singleParticipant_container);
    }

    @Override
    protected void applyBranding(AttachProperties attachProperties) {
        VectorChildFinder vector = new VectorChildFinder(this.getContext(), R.drawable.ic_attach_play_button, callButton);
        VectorDrawableCompat.VFullPath circle = vector.findPathByName("circle");
        circle.setFillColor(android.graphics.Color.parseColor(attachProperties.getVideocallButtonBackgroundColor().value));

        Color foregroundColor = Color.getForegroundColor(attachProperties.getParticipantsFocusBackgroundColor());
        userStatus.setTextColor(android.graphics.Color.parseColor(foregroundColor.value));
        userName.setTextColor(android.graphics.Color.parseColor(foregroundColor.value));

        int bgColor = android.graphics.Color.parseColor(attachProperties.getParticipantsFocusBackgroundColor().value);
        container.setBackgroundColor(bgColor);
    }

    public void setParticipant(Participant participant) {
        this.participant = participant;

        userStatus.setText(R.string.SDK_IS_HERE);
        if (TextUtils.isEmpty(participant.getUsername())) {
            userName.setText(R.string.SDK_SOMEBODY);
        } else {
            userName.setText(participant.getUsername());
        }

        participantView.setParticipant(participant);
    }

    public void setOnParticipantClickListener(OnParticipantClickListener listener) {
        if (listener == null) {
            callButton.setVisibility(GONE);
        } else {
            callButton.setOnClickListener(view -> listener.onParticipantClick(participant));
        }
    }
}
