package live.attach.ui.roomactivity.participant.collection;

import android.content.Context;
import android.graphics.Color;
import android.os.Build;
import android.support.annotation.RequiresApi;
import android.support.v7.widget.AppCompatImageView;
import android.support.v7.widget.GridLayoutManager;
import android.util.AttributeSet;
import android.view.View;

import java.util.ArrayList;
import java.util.List;

import live.attach.repackaged.io.reactivex.disposables.Disposable;
import live.attach.lib.live.attach.repackaged.io.reactivex.android.schedulers.AndroidSchedulers;
import live.attach.sdk.AttachSdkInternal;
import live.attach.sdk.R;
import live.attach.domain.model.application.AttachProperties;
import live.attach.domain.model.participant.Participant;
import live.attach.ui.roomactivity.participant.OnParticipantClickListener;
import live.attach.ui.roomactivity.participant.ParticipantsView;
import live.attach.ui.view.AttachBrandedView;
import live.attach.ui.view.common.EmptyRecyclerView;

public class CollectionParticipantsView extends AttachBrandedView {
    private CollectionParticipantsAdapter participantsAdapter;
    private AttachSdkInternal attachSdkInternal;
    private Disposable subscription;

    public CollectionParticipantsView(Context context) {
        super(context);
        init();
    }

    public CollectionParticipantsView(Context context, AttributeSet attrs) {
        super(context, attrs);
        init();
    }

    public CollectionParticipantsView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init();
    }

    @RequiresApi(api = Build.VERSION_CODES.LOLLIPOP)
    public CollectionParticipantsView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        init();
    }

    private void init() {
        attachSdkInternal = (AttachSdkInternal) getAttachActivity().getAttachSdk();
        participantsAdapter = new CollectionParticipantsAdapter();

        View root = inflate(getContext(), R.layout.roomactivity_collection_participants_view, this);
        EmptyRecyclerView recyclerView = root.findViewById(R.id.collectionParticipants_recyclerView);

        recyclerView.setLayoutManager(new GridLayoutManager(getContext(), 6));
        recyclerView.setEmptyView(findViewById(R.id.emptyParticipantsView));
        recyclerView.setAdapter(participantsAdapter);
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        subscription = attachSdkInternal
            .getRoomParticipants()
            .observeOn(AndroidSchedulers.mainThread())
            .subscribe(this::setParticipants);
    }

    @Override
    protected void onDetachedFromWindow() {
        subscription.dispose();
        super.onDetachedFromWindow();
    }

    @Override
    protected void applyBranding(AttachProperties attachProperties) {
        setBackgroundColor(Color.parseColor(attachProperties.getParticipantsViewerBackgroundColor().value));

        AppCompatImageView emptyListIcon = findViewById(R.id.collectionParticipants_emptyListIcon);
        if (attachProperties.getParticipantsViewerBackgroundColor().isLightColor()) {
            emptyListIcon.setColorFilter(android.graphics.Color.parseColor(live.attach.domain.model.application.Color.GRAY.value));
        } else {
            emptyListIcon.setColorFilter(android.graphics.Color.parseColor(live.attach.domain.model.application.Color.WHITE.value));
        }
    }

    public void setOnParticipantClickListener(OnParticipantClickListener listener) {
        this.participantsAdapter.setParticipantClickListener(listener);
    }

    private void setParticipants(List<Participant> participants) {
        int activeParticipantsSize = ParticipantsView.getActiveParticipantsSize(getContext());
        if (participants.size() == 0 || participants.size() < activeParticipantsSize) {
            participantsAdapter.setParticipants(new ArrayList<>());
        } else {
            participantsAdapter.setParticipants(participants.subList(activeParticipantsSize, participants.size()));
        }
    }
}
