package live.attach.ui.roomactivity.participant.collection;

import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import java.util.ArrayList;
import java.util.List;

import live.attach.sdk.R;
import live.attach.domain.model.participant.Participant;
import live.attach.ui.roomactivity.participant.OnParticipantClickListener;
import live.attach.ui.view.common.ParticipantView;

public class CollectionParticipantsAdapter extends RecyclerView.Adapter<CollectionParticipantsAdapter.ParticipantViewHolder> {
    private List<Participant> participants;
    private OnParticipantClickListener participantClickListener;

    CollectionParticipantsAdapter() {
        participants = new ArrayList<>();
    }

    @NonNull
    @Override
    public ParticipantViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        final LayoutInflater inflater = LayoutInflater.from(parent.getContext());
        final View view = inflater.inflate(R.layout.roomactivity_participants_collection_item, parent, false);
        return new ParticipantViewHolder(view);
    }

    @Override
    public void onBindViewHolder(@NonNull ParticipantViewHolder holder, int position) {
        Participant currentOne = participants.get(holder.getAdapterPosition());
        if (currentOne != null) {
            holder.participantView.setVisibility(View.VISIBLE);
            holder.participantView.setParticipant(currentOne);
            holder.participantView.setOnClickListener(view -> {
                if (participantClickListener != null) {
                    participantClickListener.onParticipantClick(currentOne);
                }
            });
        } else {
            holder.participantView.setVisibility(View.GONE);
        }
    }

    @Override
    public int getItemCount() {
        return participants.size();
    }

    void setParticipants(List<Participant> participants) {
        this.participants = participants;
        notifyDataSetChanged();
    }

    void setParticipantClickListener(OnParticipantClickListener participantClickListener) {
        this.participantClickListener = participantClickListener;
    }

    static class ParticipantViewHolder extends RecyclerView.ViewHolder {
        final ParticipantView participantView;

        ParticipantViewHolder(View view) {
            super(view);
            participantView = view.findViewById(R.id.participantView);
        }
    }
}