package live.attach.ui.roomactivity.participant.active;

import android.content.Context;
import android.os.Build;
import android.support.annotation.RequiresApi;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.View;
import android.widget.TextView;

import java.util.List;

import live.attach.sdk.R;
import live.attach.domain.model.application.AttachProperties;
import live.attach.domain.model.application.Color;
import live.attach.domain.model.participant.Participant;
import live.attach.ui.roomactivity.participant.OnParticipantClickListener;
import live.attach.ui.view.AttachBrandedView;

public class ActiveParticipantsView extends AttachBrandedView {
    private ActiveParticipantsAdapter participantsAdapter;
    private TextView moreParticipantsExist;
    private View.OnClickListener onMoreParticipantsClickListener;

    public ActiveParticipantsView(Context context) {
        super(context);
        init();
    }

    public ActiveParticipantsView(Context context, AttributeSet attrs) {
        super(context, attrs);
        init();
    }

    public ActiveParticipantsView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init();
    }

    @RequiresApi(api = Build.VERSION_CODES.LOLLIPOP)
    public ActiveParticipantsView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        init();
    }

    private void init() {
        participantsAdapter = new ActiveParticipantsAdapter();

        View root = inflate(getContext(), R.layout.roomactivity_active_participants_view, this);
        moreParticipantsExist = root.findViewById(R.id.activeParticipants_showMore);
        moreParticipantsExist.setOnClickListener(view -> {
            moreParticipantsExist.setVisibility(GONE);
            if (onMoreParticipantsClickListener != null) {
                onMoreParticipantsClickListener.onClick(view);
            }
        });

        RecyclerView recyclerView = root.findViewById(R.id.activeParticipants_recyclerView);
        recyclerView.setLayoutManager(new LinearLayoutManager(getContext(), LinearLayoutManager.HORIZONTAL, false));
        recyclerView.setAdapter(participantsAdapter);
    }

    public void setParticipants(List<Participant> participants, int moreExists) {
        if (participants.size() == 0) {
            moreParticipantsExist.setVisibility(INVISIBLE);
        }

        this.participantsAdapter.setParticipants(participants);
        if (participants.size() > 0 && moreExists > 0) {
            if (moreParticipantsExist.getVisibility() == INVISIBLE) {
                moreParticipantsExist.setVisibility(VISIBLE);
            }
        }
        moreParticipantsExist.setText("+" + moreExists);
    }

    @Override
    protected void applyBranding(AttachProperties attachProperties) {
        Color backgroundColor = attachProperties.getParticipantsFocusBackgroundColor();
        Color textColor = Color.getForegroundColor(backgroundColor);
        moreParticipantsExist.setTextColor(android.graphics.Color.parseColor(textColor.value));
    }

    public void setOnParticipantClickListener(OnParticipantClickListener listener) {
        this.participantsAdapter.setParticipantClickListener(listener);
    }

    public void setOnShowMoreClickListener(View.OnClickListener listener) {
        this.onMoreParticipantsClickListener = listener;
    }
}
