package live.attach.ui.roomactivity.participant.active;

import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import java.util.ArrayList;
import java.util.List;

import live.attach.sdk.R;
import live.attach.domain.model.participant.Participant;
import live.attach.ui.roomactivity.participant.OnParticipantClickListener;
import live.attach.ui.view.common.ParticipantView;

public class ActiveParticipantsAdapter extends RecyclerView.Adapter<ActiveParticipantsAdapter.ParticipantViewHolder> {
    private List<Participant> participants;
    private OnParticipantClickListener participantClickListener;

    ActiveParticipantsAdapter() {
        participants = new ArrayList<>();
    }

    @NonNull
    @Override
    public ParticipantViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        final LayoutInflater inflater = LayoutInflater.from(parent.getContext());
        View view = inflater.inflate(R.layout.roomactivity_participant, parent, false);
        return new ParticipantViewHolder(view);
    }

    @Override
    public void onBindViewHolder(@NonNull ParticipantViewHolder participantViewHolder, int position) {
        Participant currentOne = participants.get(participantViewHolder.getAdapterPosition());
        if (currentOne != null) {
            participantViewHolder.participantView.setVisibility(View.VISIBLE);
            participantViewHolder.participantView.setParticipant(currentOne);
            participantViewHolder.participantView.setOnClickListener(view -> {
                if (participantClickListener != null) {
                    participantClickListener.onParticipantClick(currentOne);
                }
            });
        } else {
            participantViewHolder.participantView.setVisibility(View.GONE);
        }
    }

    @Override
    public int getItemCount() {
        return participants.size();
    }

    void setParticipants(List<Participant> participants) {
        this.participants = participants;
        notifyDataSetChanged();
    }

    void setParticipantClickListener(OnParticipantClickListener participantClickListener) {
        this.participantClickListener = participantClickListener;
    }

    static class ParticipantViewHolder extends RecyclerView.ViewHolder {
        final ParticipantView participantView;

        ParticipantViewHolder(View view) {
            super(view);
            participantView = view.findViewById(R.id.participantView);
        }
    }
}
