package live.attach.ui.roomactivity.overlay;

import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.support.v4.view.PagerAdapter;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;

import live.attach.sdk.R;
import live.attach.domain.model.application.AttachProperties;
import live.attach.ui.roomactivity.chat.ChatView;
import live.attach.ui.roomactivity.participant.OnParticipantClickListener;
import live.attach.ui.roomactivity.participant.collection.CollectionParticipantsView;
import live.attach.ui.view.AttachBrandedView;
import live.attach.ui.view.common.CustomViewPager;

public class OverlayContentView extends AttachBrandedView {
    CustomViewPager viewPager;
    OverlayContentPagerAdapter adapter;
    private boolean chatEnabled;

    public OverlayContentView(Context context) {
        super(context);
        init();
    }

    public OverlayContentView(Context context, AttributeSet attrs) {
        super(context, attrs);
        init();
    }

    public OverlayContentView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init();
    }

    @RequiresApi(api = Build.VERSION_CODES.LOLLIPOP)
    public OverlayContentView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        init();
    }

    private void init() {
        chatEnabled = getAttachActivity().getDefaultProperties().isChatEnabled();

        View root = inflate(getContext(), R.layout.roomactivity_overlay_content_view, this);
        viewPager = root.findViewById(R.id.overlayContentView_viewPager);
        adapter = new OverlayContentPagerAdapter();
        viewPager.setAdapter(adapter);
        disablePaging();
    }

    @Override
    protected void applyBranding(AttachProperties attachProperties) {
        if (chatEnabled == attachProperties.getOverlayServices().isChatEnabled()) return;

        if (attachProperties.getOverlayServices().isChatEnabled()) {
            enablePaging();
        } else {
            viewPager.setCurrentItem(1, false);
            disablePaging();
        }
        chatEnabled = attachProperties.getOverlayServices().isChatEnabled();
    }

    public void enablePaging() {
        if (chatEnabled) {
            viewPager.setPagingEnabled(true);
        }
    }

    private void disablePaging() {
        viewPager.setPagingEnabled(false);
    }

    public void showParticipants() {
        viewPager.setCurrentItem(1, true);
    }

    public void setOnParticipantClickListener(OnParticipantClickListener listener) {
        this.adapter.setOnParticipantClickListener(listener);
    }

    public void reset() {
        viewPager.setCurrentItem(0, false);
    }

    private static class OverlayContentPagerAdapter extends PagerAdapter {
        private OnParticipantClickListener listener;

        public void setOnParticipantClickListener(OnParticipantClickListener listener) {
            this.listener = listener;
        }

        @NonNull
        @Override
        public Object instantiateItem(@NonNull ViewGroup container, int position) {
            if (position == 0) {
                View view = new ChatView(container.getContext());
                container.addView(view);
                return view;
            } else {
                CollectionParticipantsView view = new CollectionParticipantsView(container.getContext());
                view.setOnParticipantClickListener(participant -> {
                    if (listener != null) {
                        listener.onParticipantClick(participant);
                    }
                });
                container.addView(view);
                return view;
            }
        }

        @Override
        public int getCount() {
            return 2;
        }

        @Override
        public void destroyItem(@NonNull ViewGroup collection, int position, @NonNull Object view) {
            collection.removeView((View) view);
        }

        @Override
        public boolean isViewFromObject(@NonNull View view, @NonNull Object object) {
            return view == object;
        }
    }
}
