package live.attach.ui.roomactivity.chat;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import live.attach.lib.TextUtils;
import live.attach.sdk.R;
import live.attach.domain.model.application.AttachProperties;
import live.attach.domain.model.application.Color;
import live.attach.domain.model.chat.Message;
import live.attach.ui.ViewUtils;
import live.attach.ui.view.common.AttachUserImageView;
import live.attach.lib.DateUtils;

public class MessagesAdapter extends RecyclerView.Adapter<MessagesAdapter.MessageViewHolder> {
    private List<Message> items;
    private AttachProperties attachProperties;

    public MessagesAdapter(AttachProperties attachProperties) {
        items = new ArrayList<>();
        this.attachProperties = attachProperties;
    }

    public void setBrandingProperties(AttachProperties properties) {
        this.attachProperties = properties;
        notifyDataSetChanged();
    }

    @Override
    public MessageViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        final LayoutInflater inflater = LayoutInflater.from(parent.getContext());
        final View v = inflater.inflate(R.layout.roomactivity_recycler_message, parent, false);
        return new MessageViewHolder(v);
    }

    @Override
    public void onBindViewHolder(MessageViewHolder holder, int position) {
        Context context = holder.userImageView.getContext();
        Message message = items.get(position);

        boolean showFullInfo = true;

        Color bgColor = attachProperties.getChatViewerBackgroundColor();
        Color fgColor = Color.getForegroundColor(bgColor);
        int textColor = android.graphics.Color.parseColor(fgColor.value);

        holder.sentWhen.setTextColor(textColor);
        holder.userName.setTextColor(textColor);
        holder.message.setTextColor(textColor);

        if (position < items.size() - 1) {
            Message previous = items.get(position + 1);
            long previousSentWhen = previous.getSentWhen();
            showFullInfo = Math.abs(previousSentWhen - message.getSentWhen()) > 1000 * 10;
        }

        if (showFullInfo) {
            holder.userName.setVisibility(View.VISIBLE);
            holder.sentWhen.setVisibility(View.VISIBLE);
            holder.userImageView.setVisibility(View.VISIBLE);
            
            if (TextUtils.isEmpty(message.getSender().getUsername())) {
                holder.userName.setText(R.string.SDK_SOMEBODY);
            } else {
                holder.userName.setText(message.getSender().getUsername());
            }
            Date sendWhen = new Date(message.getSentWhen());
            holder.sentWhen.setText(DateUtils.formatChatDate(context, sendWhen));
            ViewUtils.loadAvatar(context, message.getSender().getAvatar(), holder.userImageView.imageView());
        } else {
            holder.userName.setText(null);
            holder.sentWhen.setText(null);
            holder.userImageView.imageView().setImageDrawable(null);

            holder.userName.setVisibility(View.GONE);
            holder.sentWhen.setVisibility(View.GONE);
            holder.userImageView.setVisibility(View.GONE);
        }
        holder.message.setText(message.getBody());
    }

    public void setMessages(List<Message> messages) {
        this.items = messages;
        notifyDataSetChanged();
    }

    @Override
    public int getItemCount() {
        return items.size();
    }

    protected static class MessageViewHolder extends RecyclerView.ViewHolder {
        private AttachUserImageView userImageView;
        private TextView userName;
        private TextView sentWhen;
        private TextView message;

        public MessageViewHolder(View view) {
            super(view);
            userImageView = view.findViewById(R.id.userPreview);
            userName = view.findViewById(R.id.userName);
            sentWhen = view.findViewById(R.id.sentWhen);
            message = view.findViewById(R.id.messageBody);
        }
    }
}