package live.attach.ui.roomactivity.call;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Color;
import android.os.Build;
import android.support.annotation.RequiresApi;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

import live.attach.lib.com.devs.vectorchildfinder.VectorChildFinder;
import live.attach.lib.com.devs.vectorchildfinder.VectorDrawableCompat;
import live.attach.sdk.R;
import live.attach.domain.model.application.AttachProperties;
import live.attach.domain.model.participant.Participant;
import live.attach.domain.model.video.VideoCall;
import live.attach.ui.view.AttachBrandedView;
import live.attach.ui.view.common.ParticipantView;
import live.attach.lib.TextUtils;

public class CallView extends AttachBrandedView {
    private ParticipantView participantView;
    private TextView userStatus;
    private TextView userName;

    private ImageView answerButton;
    private View dismissButton;
    private View container;

    public CallView(Context context) {
        super(context);
        init();
    }

    public CallView(Context context, AttributeSet attrs) {
        super(context, attrs);
        init();
    }

    public CallView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init();
    }

    @RequiresApi(api = Build.VERSION_CODES.LOLLIPOP)
    public CallView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        init();
    }

    private void init() {
        setClipChildren(false);
        setClipToPadding(false);
        View root = inflate(getContext(), R.layout.roomactivity_call_view, this);
        participantView = root.findViewById(R.id.callView_participant);
        userStatus = root.findViewById(R.id.callView_userStatus);
        userName = root.findViewById(R.id.callView_userName);
        answerButton = root.findViewById(R.id.callView_answerButton);
        dismissButton = root.findViewById(R.id.callView_dismissButton);
        container = root.findViewById(R.id.callView_container);
    }

    @Override
    protected void applyBranding(AttachProperties attachProperties) {
        container.setBackgroundColor(
            Color.parseColor(attachProperties.getVideocallFocusBackgroundColor().value)
        );
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            dismissButton.setBackgroundTintList(ColorStateList.valueOf(Color.parseColor(attachProperties.getVideocallButtonBackgroundColor().value)));
        }
        VectorChildFinder vector = new VectorChildFinder(this.getContext(), R.drawable.ic_attach_play_button, answerButton);
        VectorDrawableCompat.VFullPath circle = vector.findPathByName("circle");
        circle.setFillColor(android.graphics.Color.parseColor(attachProperties.getVideocallButtonBackgroundColor().value));
    }


    public void setOnAcceptCallClickListener(View.OnClickListener clickListener) {
        this.answerButton.setOnClickListener(clickListener);
    }

    public void setOnDismissCallClickListener(View.OnClickListener clickListener) {
        this.dismissButton.setOnClickListener(clickListener);
    }

    public void setParticipant(Participant participant, boolean incoming) {
        setVisibility(VISIBLE);
        if (incoming) {
            userStatus.setText(R.string.SDK_CALLING);
        } else {
            userStatus.setText(R.string.SDK_CALLING);
        }
        if (TextUtils.isEmpty(participant.getUsername())) {
            userName.setText(R.string.SDK_SOMEBODY);
        } else {
            userName.setText(participant.getUsername());
        }
        participantView.setParticipant(participant);

        answerButton.setVisibility(incoming ? View.VISIBLE : View.GONE);
        dismissButton.setVisibility(View.VISIBLE);
    }

    public void setStatus(VideoCall.ByeReason byeReason) {
        setVisibility(VISIBLE);
        answerButton.setVisibility(View.GONE);
        dismissButton.setVisibility(View.GONE);
        switch (byeReason) {
            case INVITE_BUSY:
                userStatus.setText(R.string.SDK_BYE_INVITE_BUSY);
                break;
            case INVITE_REJECT:
                userStatus.setText(R.string.SDK_BYE_INVITE_REJECT);
                break;
            case INVITE_CANCEL:
                userStatus.setText(R.string.SDK_BYE_INVITE_CANCEL);
                break;
            case CALL_FINISH:
                userStatus.setText(R.string.SDK_BYE_CALL_FINISH);
                break;
            case INVITE_TIMEOUT:
                userStatus.setText(R.string.SDK_BYE_INVITE_TIMEOUT);
                break;
        }
    }

    public void hide() {
        setVisibility(GONE);
    }
}
