package live.attach.ui.roomactivity;

import android.content.Context;
import android.support.design.widget.BottomSheetBehavior;
import android.support.design.widget.CoordinatorLayout;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;

import live.attach.sdk.R;

public class CustomBottomSheetBehavior<V extends View> extends BottomSheetBehavior<V> {

    public CustomBottomSheetBehavior() {
        super();
    }

    public CustomBottomSheetBehavior(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    public boolean onInterceptTouchEvent(CoordinatorLayout parent, V child, MotionEvent event) {
        ViewGroup childGroup = (ViewGroup) child;
        int x = Math.round(event.getX());
        int y = Math.round(event.getY());
        for (int i = 0; i < childGroup.getChildCount(); i++) {
            View c = childGroup.getChildAt(i);
            if (x > child.getLeft() && x < child.getRight() && y > child.getTop() && y < child.getBottom()) {
                if (c.getId() == R.id.dragView) {
                    return false;
                } else {
                    return true;
                }
            }
        }
        return true;
    }

//    @Override
//    public boolean onTouchEvent(CoordinatorLayout parent, V child, MotionEvent event) {
//
//
//    }
}
