package live.attach.ui;

import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.ImageView;

import java.util.Map;

import live.attach.lib.com.guardanis.imageloader.ImageRequest;
import live.attach.sdk.AttachSdk;
import live.attach.sdk.AttachSdkInternal;

public class ViewUtils {
    public static float convertDpToPixel(float dp) {
        DisplayMetrics metrics = Resources.getSystem().getDisplayMetrics();
        float px = dp * ((float) metrics.densityDpi / DisplayMetrics.DENSITY_DEFAULT);
        return px;
    }

    public static void loadAvatar(Context context, String url, ImageView imageView) {
        AttachSdkInternal attachSdkInternal = (AttachSdkInternal) AttachSdk.getInstance();

        if (url == null) url = "https://avatars.attach.live/default.png";

        ImageRequest imageRequest = ImageRequest.create(imageView);
        Map<String, String> assetsHeaders = attachSdkInternal.getEnvironment().getPlatformHeaders();
        if (assetsHeaders.size() > 0) {
            for (Map.Entry<String, String> e : assetsHeaders.entrySet()) {
                imageRequest.addHttpRequestParam(e.getKey(), e.getValue());
            }
        }

        imageRequest
            .setTargetUrl(url)
            .setErrorCallback((request, e) -> {
                request.setTargetUrl("https://avatars.attach.live/default.png");
                request.execute();
            })
            .execute();

//        LazyHeaders.Builder builder = new LazyHeaders.Builder();
//        Map<String, String> assetsHeaders = attachSdkInternal.getEnvironment().getPlatformHeaders();
//        if (assetsHeaders.size() > 0) {
//            for (Map.Entry<String, String> e : assetsHeaders.entrySet()) {
//                builder.addHeader(e.getKey(), e.getValue());
//            }
//        }
//
//        Context applicationContext = context.getApplicationContext();
//
//        GlideUrl glideUrl = new GlideUrl(url, builder.build());
//        Glide.with(applicationContext)
//            .load(glideUrl)
//            .listener(new SvgSoftwareLayerSetter())
//            .error(
//                Glide.with(applicationContext).load(glideUrl)
//                    .error(
//                        Glide.with(applicationContext).load("https://avatars.attach.live/default.png")
//                    )
//            )
//            .into(imageView);
    }

    public static float convertPixelsToDp(float px) {
        DisplayMetrics metrics = Resources.getSystem().getDisplayMetrics();
        float dp = px / ((float) metrics.densityDpi / DisplayMetrics.DENSITY_DEFAULT);
        return dp;
    }

    public static void hideKeyboard(Activity activity) {
        InputMethodManager imm = (InputMethodManager) activity.getSystemService(Activity.INPUT_METHOD_SERVICE);
        //Find the currently focused view, so we can grab the correct window token from it.
        View view = activity.getCurrentFocus();
        //If no view currently has focus, create a new one, just so we can grab a window token from it.
        if (view == null) {
            view = new View(activity);
        }
        imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
    }

    public static int getScreenWidth() {
        return Resources.getSystem().getDisplayMetrics().widthPixels;
    }

    public static int getScreenHeight() {
        return Resources.getSystem().getDisplayMetrics().heightPixels;
    }

    public static boolean isPortrait(Context context) {
        return context.getResources().getConfiguration().orientation == Configuration.ORIENTATION_PORTRAIT;
    }
}
