package live.attach.ui;

import android.content.Context;
import android.media.MediaPlayer;

import live.attach.sdk.R;

public class SoundNotifier {
    private MediaPlayer ringPlayer;
    private MediaPlayer connectPlayer;
    private MediaPlayer disconnectPlayer;

    public SoundNotifier(Context context) {
        ringPlayer = MediaPlayer.create(context, R.raw.ring);
        ringPlayer.setLooping(true);
        connectPlayer = MediaPlayer.create(context, R.raw.connect);
        disconnectPlayer = MediaPlayer.create(context, R.raw.disconnect);
    }

    public void playRing() {
        stopAll();
        ringPlayer.start();
    }

    public void playConnect() {
        stopAll();
        connectPlayer.start();
    }

    public void playDisconnect() {
        stopAll();
        disconnectPlayer.start();
    }

    public void stopAll() {
        stopMediaPlayer(ringPlayer);
        stopMediaPlayer(connectPlayer);
        stopMediaPlayer(disconnectPlayer);
    }

    private void stopMediaPlayer(MediaPlayer mediaPlayer) {
        if (mediaPlayer.isPlaying()) {
            mediaPlayer.pause();
            mediaPlayer.seekTo(0);
        }
    }
}
