package live.attach.sdk;

import live.attach.lib.TextUtils;

/**
 * This is the Room class.   It is used to pass the room into the SDK.
 * @see  <a href="https://documentation.attach.live/android/concepts/rooms/">Documentation</a>
 */
public class Room {
    public final String provider;
    public final String type;
    public final String identifier;
    public final String url;

    /**
     * Class constructor specifying provider, type and identifier properties.
     *
     * @param provider    the provider of the room, required
     * @param type        the type of the room, required
     * @param identifier  the identifier of the room, required
     */
    public Room(String provider, String type, String identifier) {
        if (TextUtils.isEmpty(provider) || TextUtils.isEmpty(type) || TextUtils.isEmpty(identifier)) {
            throw new IllegalArgumentException("'provider', 'type' and 'identifier' cannot be 'null'.");
        }
        this.provider = provider;
        this.type = type;
        this.identifier = identifier;
        this.url = null;
    }

    /**
     * Class constructor specifying a URL.
     *
     * @param url  the URL of the room, required
     */
    public Room(String url) {
        if (TextUtils.isEmpty(url)) {
            throw new IllegalArgumentException("'url' cannot be 'null'.");
        }
        this.provider = null;
        this.type = null;
        this.identifier = null;
        this.url = url;
    }
}
