package live.attach.sdk;

import java.util.HashMap;
import java.util.Map;

/**
 * This is the Properties class.   Properties determine look and behavior of ATTACH activities and views.
 * @see  <a href="https://github.com/attach-live/attach-sdk-properties/">Properties collection</a>
 */
public class Properties {
    private final Map<String, String> properties;

    /**
     * Class constructor.
     */
    public Properties() {
        this.properties = new HashMap<>();
    }

    /**
     * Class constructor specifying properties.
     *
     * @param properties  a map with key-value pairs of property name and value
     */
    public Properties(Map<String, String> properties) {
        this();
        this.properties.putAll(properties);
    }

    /**
     * Sets a property.
     *
     * @param property  the property name
     * @param value     the new value for the property
     */
    public Properties setProperty(String property, String value) {
        this.properties.put(property, value);
        return this;
    }

    /**
     * Sets multiple properties.
     *
     * @param properties  a map with key-value pairs of property name and value
     */
    public Properties setProperties(Map<String, String> properties) {
        this.properties.putAll(properties);
        return this;
    }

    Map<String, String> getProperties() {
        return properties;
    }
}
