package live.attach.lib.com.guardanis.imageloader.processors;

import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;

import java.io.File;
import java.util.List;

import live.attach.lib.com.guardanis.imageloader.ImageRequest;
import live.attach.lib.com.guardanis.imageloader.ImageUtils;
import live.attach.lib.com.guardanis.imageloader.filters.ImageFilter;

import static live.attach.lib.com.guardanis.imageloader.ImageUtils.ImageType.*;

public class ImageFileProcessor extends ImageProcessor {

    @Override
    public Drawable process(ImageRequest request, List<ImageFilter<Bitmap>> bitmapImageFilters) throws Exception {
        File target = new File(request.getTargetUrl());

        switch(request.getTargetImageType()){
            case BITMAP:
            case SVG:
            default:
                return processBitmap(request, target, bitmapImageFilters);
        }
    }

    protected Drawable processBitmap(ImageRequest request, File originalFile, List<ImageFilter<Bitmap>> bitmapImageFilters) throws Exception {
        File editedImageFile = request.getEditedRequestFile();
        int requiredImageWidth = request.getTargetImageWidth();

        if(editedImageFile.exists())
            return decodeBitmapDrawable(request.getContext(),
                    editedImageFile,
                    requiredImageWidth);

        if(originalFile.exists())
            return process(request.getContext(),
                    ImageUtils.decodeFile(originalFile, requiredImageWidth),
                    editedImageFile,
                    bitmapImageFilters);

        return null;
    }
}
