package live.attach.lib.com.guardanis.imageloader.processors;

import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;

import java.io.File;
import java.util.List;

import live.attach.lib.com.guardanis.imageloader.ImageRequest;
import live.attach.lib.com.guardanis.imageloader.ImageUtils;
import live.attach.lib.com.guardanis.imageloader.filters.ImageFilter;

public class ImageDrawableResourceProcessor extends ImageFileProcessor {

    @Override
    public Drawable process(ImageRequest request, List<ImageFilter<Bitmap>> bitmapImageFilters) throws Exception {
        File editedImageFile = request.getEditedRequestFile();
        int requiredImageWidth = request.getTargetImageWidth();

        if(editedImageFile.exists())
            return decodeBitmapDrawable(request.getContext(), editedImageFile, requiredImageWidth);

        Bitmap uneditedBitmap = ImageUtils.decodeDrawableResource(request.getContext(), request.getTargetResourceId(), requiredImageWidth);

        return process(request.getContext(), uneditedBitmap, editedImageFile, bitmapImageFilters);
    }
}
