package live.attach.lib;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;

public class EnumUtils {

    public static <E extends Enum<E>> E valueOfIgnoreCaseOrNull(String string, Class<E> cls) {
        if (string != null) {
            string = string.trim();
            for (E value : EnumSet.allOf(cls)) {
                if (value.toString().equalsIgnoreCase(string)) {
                    return value;
                }
            }
        }
        return null;
    }

    public static <E extends Enum<E>> E valueOfIgnoreCaseOrDefault(String string, Class<E> cls, E defaultValue) {
        if (string != null) {
            string = string.trim();
            for (E value : EnumSet.allOf(cls)) {
                if (value.toString().equalsIgnoreCase(string)) {
                    return value;
                }
            }
        }
        return defaultValue;
    }

    public static <E extends Enum<E>> String toStringOrNull(E value) {
        if (value == null) {
            return null;
        }

        return value.toString();
    }

    public static <E extends Enum<E>> String toStringOrDefault(E value, E defaultValue) {
        if (value == null) {
            return defaultValue.toString();
        }

        return value.toString();
    }

    public static <E extends Enum<E>> Set<E> mapAllToEnum(Set<String> strings, Class<E> cls) {
        if (strings == null) {
            return new HashSet<>(0);
        }

        Set<E> values = new HashSet<>(strings.size());
        for (String string : strings) {
            E value = valueOfIgnoreCaseOrNull(string, cls);
            if (value != null) {
                values.add(value);
            }
        }
        return values;
    }

    public static <E extends Enum<E>> Set<String> mapAllFromEnum(Set<E> values) {
        if (values == null) {
            return new HashSet<>(0);
        }

        Set<String> strings = new HashSet<>(values.size());
        for (E value : values) {
            if (value != null) {
                strings.add(value.toString());
            }
        }
        return strings;
    }
}

