package live.attach.lib;

import java.util.ArrayList;
import java.util.List;

public class EmptySlotsDistinctList<T> {
    private ArrayList<T> list;

    public EmptySlotsDistinctList() {
        list = new ArrayList<>();
    }

    public int size() {
        int size = 0;
        for (int i = 0; i < list.size(); i++) {
            if (list.get(i) != null) size++;
        }
        return size;
    }

    public void add(T t) {
        if (list.contains(t)) return;

        int index = list.size();
        for (int i = 0; i < size(); i++) {
            if (list.get(i) == null) {
                index = i;
                break;
            }
        }
        if (index >= list.size()) {
            list.add(t);
        } else {
            list.set(index, t);
        }
    }

    public boolean contains(T t) {
        return list.contains(t);
    }

    public int indexOf(T t) {
        return list.indexOf(t);
    }

    public List<T> asList() {
        return list;
    }

    public void clear() {
        this.list.clear();
    }

    private int findFirst(Predicate<T> predicate) {
        for (int i = 0; i < list.size(); i++) {
            if (list.get(i) != null && predicate.test(list.get(i))) {
                return i;
            }
        }
        return -1;
    }

    public void removeFirst(Predicate<T> predicate) {
        int index = findFirst(predicate);
        if (index >= 0) {
            remove(index);
        }
    }

    public void removeFirst(T element) {
        removeFirst(element::equals);
    }

    private void remove(int i) {
        list.set(i, null);
        trim();
    }

    private void trim() {
        for (int i = list.size() - 1; i >= 0; i--) {
            if (list.get(i) != null) break;
            list.remove(i);
        }
    }

    public interface Predicate<T> {
        boolean test(T t);
    }
}
