package live.attach.lib;

import android.content.Context;
import android.text.format.DateFormat;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateUtils {
    private static SimpleDateFormat HH_mm = new SimpleDateFormat("HH:mm");

    public static boolean isToday(Date date) {
        Calendar calendar1 = Calendar.getInstance();
        Calendar calendar2 = Calendar.getInstance();

        calendar1.setTime(date);
        calendar2.setTime(new Date());
        boolean sameDay =
            calendar1.get(Calendar.YEAR) == calendar2.get(Calendar.YEAR) && calendar1.get(Calendar.DAY_OF_YEAR) == calendar2.get(Calendar.DAY_OF_YEAR);
        return sameDay;
    }

    public static String formatChatDate(Context context, Date date) {
        if (isToday(date)) {
            return HH_mm.format(date);
        } else {
            return DateFormat.getDateFormat(context).format(date);
        }
    }
}
