package live.attach.infrastructure.octopus.video.webrtc.mapper;

import org.webrtc.PeerConnection;

import java.util.LinkedList;
import java.util.List;

import live.attach.domain.model.video.IceServer;

public class IceServerConverter {
    public static PeerConnection.IceServer toPcIceServer(IceServer iceServer) {
        return new PeerConnection.IceServer(
                iceServer.uri,
                iceServer.username != null ? iceServer.username : "",
                iceServer.password != null ? iceServer.password : ""
        );
    }

    public static List<PeerConnection.IceServer> toPcIceServers(List<IceServer> iceServers) {
        List<PeerConnection.IceServer> pcIceServers = new LinkedList<>();
        for (IceServer iceServer : iceServers) {
            PeerConnection.IceServer pcIceServer = toPcIceServer(iceServer);
            pcIceServers.add(pcIceServer);
        }
        return pcIceServers;
    }
}
