package live.attach.infrastructure.octopus.socket.dto.response;

import java.util.List;

import live.attach.domain.model.video.IceServer;
import live.attach.domain.model.video.Sdp;

public class ParticipantOfferResponsePayload {
    public Data data;
    public Meta meta;

    public ParticipantOfferResponsePayload(Data data, Meta meta) {
        this.data = data;
        this.meta = meta;
    }

    public static class Data {
        public String socketId;
        public Sdp sdp;

        public Data(String socketId, Sdp sdp) {
            this.socketId = socketId;
            this.sdp = sdp;
        }
    }

    public static class Meta {
        public Options options;

        public Meta(Options options) {
            this.options = options;
        }

        public static class Options {
            public List<IceServer> iceServers;

            public Options(List<IceServer> iceServers) {
                this.iceServers = iceServers;
            }
        }
    }
}
