package live.attach.infrastructure.octopus.socket.dto.response;

import java.util.ArrayList;
import java.util.List;

import live.attach.domain.model.session.User;
import live.attach.domain.model.chat.Message;
import live.attach.domain.model.participant.Participant;
import live.attach.domain.model.video.IceServer;

public class Mapper {
    public static Participant getParticipant(ParticipantInviteResponsePayload participantInviteResponsePayload) {
        return new Participant(
            participantInviteResponsePayload.data.socketId,
            participantInviteResponsePayload.data.user.id,
            participantInviteResponsePayload.data.user.avatar,
            participantInviteResponsePayload.data.user.username
        );
    }

    public static List<IceServer> getIceServers(ParticipantInviteResponsePayload participantInviteResponsePayload) {
        return participantInviteResponsePayload.meta.options.iceServers;
    }

    public static List<Message> getMessages(MessagesResponsePayload messagesResponse) {
        List<Message> messages = new ArrayList<>();
        for (MessagesResponsePayload.Message m : messagesResponse.data) {
            Message.Category category = Message.Category.UNKNOWN;
            try {
                category = Message.Category.valueOf(m.category);
            } catch (Exception e) {

            }
            messages.add(new Message(
                m.id,
                new User(
                    m.sender.id,
                    m.sender.avatar,
                    m.sender.username
                ),
                m.body,
                m.sentWhen,
                category
            ));
        }
        return messages;
    }

    public static Message getMessage(MessageResponsePayload messageResponse) {
        MessageResponsePayload.Message m = messageResponse.data;
        Message.Category category = Message.Category.UNKNOWN;
        try {
            category = Message.Category.valueOf(m.category);
        } catch (Exception e) {

        }
        return new Message(
            m.id,
            new User(
                m.sender.id,
                m.sender.avatar,
                m.sender.username
            ),
            m.body,
            m.sentWhen,
            category
        );
    }
}
