package live.attach.infrastructure.octopus.socket.dto.request;

import live.attach.domain.model.video.Candidate;
import live.attach.domain.model.video.Sdp;

public class RequestFactory {
    public static ParticipantInviteRequestPayload participantInvite(String socketId) {
        return new ParticipantInviteRequestPayload(new ParticipantInviteRequestPayload.Data(socketId));
    }

    public static ParticipantOfferRequestPayload participantOffer(String socketId, Sdp sdp) {
        return new ParticipantOfferRequestPayload(new ParticipantOfferRequestPayload.Data(socketId, sdp));
    }

    public static ParticipantAnswerRequestPayload participantAnswer(String socketId, Sdp sdp) {
        return new ParticipantAnswerRequestPayload(new ParticipantAnswerRequestPayload.Data(socketId, sdp));
    }

    public static ParticipantCandidateRequestPayload participantCandidate(String socketId, Candidate candidate) {
        return new ParticipantCandidateRequestPayload(new ParticipantCandidateRequestPayload.Data(socketId, candidate));
    }

    public static ParticipantByeRequestPayload participantBye(String socketId, String reason) {
        return new ParticipantByeRequestPayload(
            new ParticipantByeRequestPayload.Data(socketId),
            new ParticipantByeRequestPayload.Meta(reason)
        );
    }
}
