package live.attach.infrastructure.octopus.socket;

import javax.net.ssl.SSLContext;

import live.attach.repackaged.io.socket.client.IO;
import live.attach.repackaged.io.socket.client.Socket;
import okhttp3.OkHttpClient;

class OctopusSocketIO {
    static Socket getSocket(String host) throws Exception {
        IO.Options ioOptions = new IO.Options();
        ioOptions.reconnection = false;
        ioOptions.transports = new String[]{"websocket", "polling"};
        ioOptions.multiplex = true;
        ioOptions.timeout = 15000;
        ioOptions.secure = true;
        String sslProtocol = "TLSv1.2";

        SSLContext sslContext = SSLContext.getInstance(sslProtocol);
        sslContext.init(null, null, null);
        OkHttpClient okHttpClient = new OkHttpClient.Builder()
            .sslSocketFactory(sslContext.getSocketFactory())
            .build();
        ioOptions.callFactory = okHttpClient;
        ioOptions.webSocketFactory = okHttpClient;

        return IO.socket(host, ioOptions);

    }
}
