package live.attach.infrastructure.octopus.rest.dto.mapper;

import live.attach.domain.model.participant.Participant;
import live.attach.domain.model.session.Application;
import live.attach.domain.model.session.Session;
import live.attach.infrastructure.octopus.rest.dto.SessionResponse;

public class SessionMapper {
    public static Session mapSessionResponse(SessionResponse sessionResponse) {
        return Session.valid(
            sessionResponse.meta.session.token,
            "https://" + sessionResponse.meta.server.hostname,
            new Participant(
                sessionResponse.meta.participant.socketId,
                sessionResponse.meta.participant.user.id,
                sessionResponse.meta.participant.user.avatar,
                sessionResponse.meta.participant.user.username
            ),
            new Application(
                sessionResponse.meta.session.options.isDevelopment,
                sessionResponse.meta.session.options.isGenuine
            )
        );
    }
}
