package live.attach.infrastructure.octopus.rest.dto.mapper;

import live.attach.domain.model.item.ItemId;
import live.attach.domain.model.session.RoomSession;
import live.attach.domain.model.session.Session;
import live.attach.infrastructure.octopus.rest.dto.RoomSessionResponse;

public class RoomSessionMapper {
    public static RoomSession mapRoomSessionResponse(Session session, RoomSessionResponse roomSessionResponse) {
        return RoomSession.valid(
            session,
            roomSessionResponse.meta.room.token,
            new ItemId(
                roomSessionResponse.data.provider,
                roomSessionResponse.data.type,
                roomSessionResponse.data.identifier
            ),
            "https://" + roomSessionResponse.meta.server.hostname
        );
    }
}
